/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BonemealHandler {
    private static final List<AbstractBehaviorData> BONE_MEAL_BEHAVIORS = Lists.newArrayList();
    private static Map<class_2248, BonemealBehavior> blockToBehavior;

    public static EventResult onBonemeal(class_1937 level, class_2338 pos, class_2680 block, class_1799 stack) {
        BonemealHandler.dissolve();
        BonemealBehavior behavior = blockToBehavior.get(block.method_26204());
        if (behavior != null && behavior.method_9651((class_4538)level, pos, block, level.field_9236)) {
            if (level instanceof class_3218 && behavior.method_9650(level, level.field_9229, pos, block)) {
                behavior.method_9652((class_3218)level, level.field_9229, pos, block);
            }
            return EventResult.ALLOW;
        }
        return EventResult.PASS;
    }

    private static void dissolve() {
        if (blockToBehavior == null) {
            HashMap map = Maps.newHashMap();
            for (AbstractBehaviorData behavior : BONE_MEAL_BEHAVIORS) {
                if (!behavior.allow()) continue;
                behavior.compile(map);
            }
            blockToBehavior = map;
        }
    }

    public static void invalidate() {
        blockToBehavior = null;
    }

    public static void registerBehavior(class_2248 block, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockBehaviorData(block, factory, config));
    }

    public static void registerBehavior(Set<class_2248> blocks, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new MultiBlockBehaviorData(blocks, factory, config));
    }

    public static void registerBehavior(class_6862<class_2248> tag, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
        BONE_MEAL_BEHAVIORS.add(new BlockTagBehaviorData(tag, factory, config));
    }

    private static abstract class AbstractBehaviorData {
        final BonemealBehavior behavior;
        private final BooleanSupplier config;

        public AbstractBehaviorData(Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            this.behavior = factory.get();
            this.config = config;
        }

        public abstract void compile(Map<class_2248, BonemealBehavior> var1);

        public boolean allow() {
            return this.config.getAsBoolean();
        }
    }

    private static class BlockBehaviorData
    extends AbstractBehaviorData {
        private final class_2248 block;

        public BlockBehaviorData(class_2248 block, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.block = block;
        }

        @Override
        public void compile(Map<class_2248, BonemealBehavior> map) {
            map.put(this.block, this.behavior);
        }
    }

    private static class MultiBlockBehaviorData
    extends AbstractBehaviorData {
        private final Set<class_2248> targets;

        public MultiBlockBehaviorData(Set<class_2248> targets, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.targets = targets;
        }

        @Override
        public void compile(Map<class_2248, BonemealBehavior> map) {
            for (class_2248 target : this.targets) {
                map.put(target, this.behavior);
            }
        }
    }

    private static class BlockTagBehaviorData
    extends AbstractBehaviorData {
        private final class_6862<class_2248> tag;

        public BlockTagBehaviorData(class_6862<class_2248> tag, Supplier<BonemealBehavior> factory, BooleanSupplier config) {
            super(factory, config);
            this.tag = tag;
        }

        @Override
        public void compile(Map<class_2248, BonemealBehavior> map) {
            for (class_6880 value : class_7923.field_41175.method_40286(this.tag)) {
                map.putIfAbsent((class_2248)value.comp_349(), this.behavior);
            }
        }
    }
}

