/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.eatanomelette.registry;

import forge.net.jason13.eatanomelette.content.EnchantedGoldenCakeBlock;
import forge.net.jason13.eatanomelette.content.EnchantedGoldenOmeletteItem;
import forge.net.jason13.eatanomelette.content.GoldenCakeBlock;
import forge.net.jason13.eatanomelette.content.SpanishPotatoOmeletteBlock;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class GlobalRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"eatanomelette");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"eatanomelette");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"eatanomelette");
    public static final RegistryObject<CakeBlock> SPANISH_POTATO_OMELETTE = GlobalRegistry.registerCakeBlock("spanish_potato_omelette", () -> new SpanishPotatoOmeletteBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<CakeBlock> GOLDEN_SPANISH_POTATO_OMELETTE = GlobalRegistry.registerEnchantedCakeBlock("golden_spanish_potato_omelette", () -> new GoldenCakeBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<CakeBlock> ENCHANTED_GOLDEN_SPANISH_POTATO_OMELETTE = GlobalRegistry.registerEnchantedCakeBlock("enchanted_golden_spanish_potato_omelette", () -> new EnchantedGoldenCakeBlock(BlockBehaviour.Properties.m_284310_().m_60978_(0.5f).m_60918_(SoundType.f_56745_)));
    public static final RegistryObject<Item> OMELETTE = ITEMS.register("omelette", () -> new Item(new Item.Properties().m_41487_(1).m_41489_(new FoodProperties.Builder().m_38760_(4).m_38758_(4.0f).m_38767_())));
    public static final RegistryObject<Item> GOLDEN_OMELETTE = ITEMS.register("golden_omelette", () -> new Item(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE).m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(8.0f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 100, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19617_, 2400, 0), 1.0f).m_38765_().m_38767_())));
    public static final RegistryObject<Item> ENCHANTED_GOLDEN_OMELETTE = ITEMS.register("enchanted_golden_omelette", () -> new EnchantedGoldenOmeletteItem(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(8.0f).m_38762_(new MobEffectInstance(MobEffects.f_19605_, 400, 1), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19606_, 6000, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19607_, 6000, 0), 1.0f).m_38762_(new MobEffectInstance(MobEffects.f_19617_, 2400, 3), 1.0f).m_38765_().m_38767_())));
    public static final RegistryObject<Item> SPANISH_OMELETTE_MIX = ITEMS.register("spanish_omelette_mix", () -> new Item(new Item.Properties()));
    public static final RegistryObject<CreativeModeTab> EAO_TAB = CREATIVE_MODE_TABS.register("eao_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"creativemodetab.eao_tab")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).m_257737_(() -> ((Item)OMELETTE.get()).m_7968_()).m_257501_((itemDisplayParameters, output) -> {
        output.m_246326_((ItemLike)SPANISH_POTATO_OMELETTE.get());
        output.m_246326_((ItemLike)GOLDEN_SPANISH_POTATO_OMELETTE.get());
        output.m_246326_((ItemLike)ENCHANTED_GOLDEN_SPANISH_POTATO_OMELETTE.get());
        output.m_246326_((ItemLike)OMELETTE.get());
        output.m_246326_((ItemLike)GOLDEN_OMELETTE.get());
        output.m_246326_((ItemLike)ENCHANTED_GOLDEN_OMELETTE.get());
        output.m_246326_((ItemLike)SPANISH_OMELETTE_MIX.get());
    }).m_257652_());

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        CREATIVE_MODE_TABS.register(eventBus);
    }

    private static <T extends Block> RegistryObject<T> registerCakeBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        GlobalRegistry.registerCakeBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerEnchantedCakeBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        GlobalRegistry.registerEnchantedCakeBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<Item> registerCakeBlockItem(String name, RegistryObject<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41487_(1)));
    }

    private static <T extends Block> RegistryObject<Item> registerEnchantedCakeBlockItem(String name, RegistryObject<T> block) {
        return ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)));
    }
}

