/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.moreusefulcopper;

import forge.net.jason13.moreusefulcopper.CommonClass;
import forge.net.jason13.moreusefulcopper.CommonConstants;
import forge.net.jason13.moreusefulcopper.entity.client.CopperGolemModel;
import forge.net.jason13.moreusefulcopper.entity.client.CopperGolemRenderer;
import forge.net.jason13.moreusefulcopper.entity.custom.CopperGolemEntity;
import forge.net.jason13.moreusefulcopper.entity.layer.ModModelLayers;
import forge.net.jason13.moreusefulcopper.loot.ModLootModifiers;
import forge.net.jason13.moreusefulcopper.registry.ForgeRegistry;
import net.jason13.monolib.methods.BlockMethods;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="moreusefulcopper")
public class ForgeExampleMod {
    public boolean debuggingEnabled = false;

    public ForgeExampleMod() {
        CommonConstants.LOG.info("Hello Forge world!");
        CommonClass.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        ForgeRegistry.register(bus);
        ModLootModifiers.register(bus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public void onStartTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                boolean leftHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21206_());
                boolean rightHandCommand = BlockMethods.compareBlockToItemStack((Block)Blocks.f_50272_, (ItemStack)player.m_21205_());
                if (this.debuggingEnabled || !leftHandCommand || !rightHandCommand) continue;
                this.debuggingEnabled = true;
                player.m_213846_((Component)Component.m_237113_((String)"debuggingEnabledMoreUsefulCopper"));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="moreusefulcopper", bus=Mod.EventBusSubscriber.Bus.MOD)
    public class ModEvents {
        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(ModModelLayers.COPPER_GOLEM_LAYER, CopperGolemModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerAttributes(EntityAttributeCreationEvent event) {
            event.put((EntityType)ForgeRegistry.COPPER_GOLEM.get(), CopperGolemEntity.createAttributes().m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="moreusefulcopper", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> EntityRenderers.m_174036_((EntityType)((EntityType)ForgeRegistry.COPPER_GOLEM.get()), CopperGolemRenderer::new));
        }
    }
}

