/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util;

import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2266;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2372;
import net.minecraft.class_2374;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3922;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import org.apache.commons.lang3.tuple.Pair;

public class OxygenUtils {
    public static final Map<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>> OXYGEN_LOCATIONS = new HashMap<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>>();

    public static boolean levelHasOxygen(class_1937 level) {
        if (!PlanetData.isOxygenated((class_5321<class_1937>)level.method_27983())) {
            return !ModUtils.isSpacelevel(level);
        }
        return true;
    }

    public static boolean entityHasOxygen(class_1937 level, class_1309 entity) {
        return OxygenUtils.posHasOxygen(level, class_2338.method_49638((class_2374)entity.method_33571()));
    }

    public static boolean posHasOxygen(class_1937 level, class_2338 pos) {
        if (!level.method_22340(pos)) {
            return true;
        }
        if (OxygenUtils.levelHasOxygen(level)) {
            return true;
        }
        return OxygenUtils.inDistributorBubble(level, pos);
    }

    public static boolean inDistributorBubble(class_1937 level, class_2338 pos) {
        for (Map.Entry<Pair<class_5321<class_1937>, class_2338>, Set<class_2338>> entry : OXYGEN_LOCATIONS.entrySet()) {
            if (!level.method_27983().equals(entry.getKey().getLeft()) || !entry.getValue().contains(pos)) continue;
            return true;
        }
        return false;
    }

    public static int getOxygenBlocksCount(class_1937 level, class_2338 source) {
        return OXYGEN_LOCATIONS.getOrDefault(OxygenUtils.getOxygenSource(level, source), Set.of()).size();
    }

    public static void setEntry(class_1937 level, class_2338 source, Set<class_2338> entries) {
        HashSet<class_2338> changedPositions;
        if (!level.field_9236 && OXYGEN_LOCATIONS.containsKey(OxygenUtils.getOxygenSource(level, source)) && (changedPositions = new HashSet<class_2338>((Collection)OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource(level, source)))) != null && !changedPositions.isEmpty()) {
            changedPositions.removeAll(entries);
            OxygenUtils.deoxygenizeBlocks((class_3218)level, changedPositions, source);
        }
        OXYGEN_LOCATIONS.put(OxygenUtils.getOxygenSource(level, source), entries);
    }

    public static void removeEntry(class_1937 level, class_2338 source) {
        OxygenUtils.setEntry(level, source, Set.of());
    }

    public static void deoxygenizeBlocks(class_3218 level, Set<class_2338> entries, class_2338 source) {
        try {
            if (entries == null) {
                return;
            }
            if (entries.isEmpty()) {
                return;
            }
            if (OxygenUtils.levelHasOxygen((class_1937)level)) {
                OXYGEN_LOCATIONS.remove(OxygenUtils.getOxygenSource((class_1937)level, source));
                return;
            }
            for (class_2338 pos : new HashSet<class_2338>(entries)) {
                class_2680 state = level.method_8320(pos);
                OXYGEN_LOCATIONS.get(OxygenUtils.getOxygenSource((class_1937)level, source)).remove(pos);
                if (OxygenUtils.posHasOxygen((class_1937)level, pos) || state.method_26215()) continue;
                class_2248 block = state.method_26204();
                if (block instanceof class_2555 && !block.equals(class_2246.field_22093)) {
                    level.method_8501(pos, (class_2680)((class_2248)ModBlocks.WALL_EXTINGUISHED_TORCH.get()).method_9564().method_11657((class_2769)class_2555.field_11731, (Comparable)((class_2350)state.method_11654((class_2769)class_2555.field_11731))));
                    continue;
                }
                if (!(!(block instanceof class_2527) || block.equals(class_2246.field_22092) || block.equals(class_2246.field_22093) || block.equals(class_2246.field_10523) || block.equals(class_2246.field_10301))) {
                    level.method_8501(pos, ((class_2248)ModBlocks.EXTINGUISHED_TORCH.get()).method_9564());
                    continue;
                }
                if (block instanceof class_5545) {
                    level.method_8501(pos, (class_2680)block.method_9564().method_11657((class_2769)class_5545.field_27183, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof class_5544) {
                    level.method_8501(pos, (class_2680)((class_2680)block.method_9564().method_11657((class_2769)class_5544.field_27174, (Comparable)((Integer)state.method_11654((class_2769)class_5544.field_27174)))).method_11657((class_2769)class_5544.field_27175, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (block instanceof class_2358) {
                    level.method_8650(pos, false);
                    continue;
                }
                if (block instanceof class_3922) {
                    level.method_8501(pos, (class_2680)((class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_3922.field_17564, (Comparable)((class_2350)state.method_11654((class_2769)class_3922.field_17564))));
                    continue;
                }
                if (block instanceof class_2372) {
                    level.method_8501(pos, class_2246.field_10566.method_9564());
                    continue;
                }
                if (block instanceof class_2261 || block instanceof class_2266 || block instanceof class_2541) {
                    level.method_8650(pos, true);
                    continue;
                }
                if (block instanceof class_2344) {
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(0)));
                    continue;
                }
                if (!state.method_26227().method_15767(class_3486.field_15517)) continue;
                if (!block.equals(ModBlocks.CRYO_FUEL_BLOCK.get())) {
                    if (ModUtils.getWorldTemperature((class_1937)level) < 0.0f) {
                        level.method_8501(pos, class_2246.field_10295.method_9564());
                        continue;
                    }
                    level.method_8501(pos, class_2246.field_10124.method_9564());
                    continue;
                }
                if (!state.method_28498((class_2769)class_2741.field_12508)) continue;
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
            }
        }
        catch (UnsupportedOperationException e) {
            AdAstra.LOGGER.error("Error deoxygenizing blocks");
            e.printStackTrace();
        }
    }

    private static Pair<class_5321<class_1937>, class_2338> getOxygenSource(class_1937 level, class_2338 source) {
        return Pair.of((Object)level.method_27983(), (Object)source);
    }
}

