/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.entity.vehicle;

import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.item.vehicle.VehicleItem;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.ad_astra.common.screen.VehicleScreenMenuProvider;
import earth.terrarium.ad_astra.common.util.CustomInventory;
import earth.terrarium.ad_astra.common.util.FluidUtils;
import earth.terrarium.ad_astra.common.util.OxygenUtils;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.SimpleFluidContainer;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.common.menu.ExtraDataMenuProvider;
import earth.terrarium.botarium.common.menu.MenuHooks;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_6328;

@class_6328
public abstract class Vehicle
extends class_1297 {
    protected static final class_2940<Float> SPEED = class_2945.method_12791(Vehicle.class, (class_2941)class_2943.field_13320);
    private final SimpleFluidContainer tank = new SimpleFluidContainer(this.getTankSize(), 1, (amount, fluid) -> true);
    private final CustomInventory inventory = new CustomInventory(this.getInventorySize());
    public double clientYaw;
    public double clientPitch;
    public float previousYaw;
    protected double clientX;
    protected double clientY;
    protected double clientZ;
    protected double clientXVelocity;
    protected double clientYVelocity;
    protected double clientZVelocity;
    private int clientInterpolationSteps;

    public Vehicle(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693() {
        this.field_6011.method_12784(SPEED, (Object)Float.valueOf(0.0f));
    }

    protected void method_5749(class_2487 nbt) {
        this.inventory.method_7659(nbt.method_10554("Inventory", 10));
        this.getTankHolder().deserialize(nbt.method_10562("InputFluid"));
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660());
        nbt.method_10566("InputFluid", (class_2520)this.getTankHolder().serialize());
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.clientX = x;
        this.clientY = y;
        this.clientZ = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.clientInterpolationSteps = 10;
        this.method_18800(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    private void updatePositionAndRotation() {
        if (this.method_5787()) {
            this.clientInterpolationSteps = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.clientInterpolationSteps <= 0) {
            return;
        }
        double d = this.method_23317() + (this.clientX - this.method_23317()) / (double)this.clientInterpolationSteps;
        double e = this.method_23318() + (this.clientY - this.method_23318()) / (double)this.clientInterpolationSteps;
        double f = this.method_23321() + (this.clientZ - this.method_23321()) / (double)this.clientInterpolationSteps;
        double g = class_3532.method_15338((double)(this.clientYaw - (double)this.method_36454()));
        this.method_36456(this.method_36454() + (float)g / (float)this.clientInterpolationSteps);
        this.method_36457(this.method_36455() + (float)(this.clientPitch - (double)this.method_36455()) / (float)this.clientInterpolationSteps);
        --this.clientInterpolationSteps;
        this.method_5814(d, e, f);
        this.method_5710(this.method_36454(), this.method_36455());
    }

    public void method_5750(double x, double y, double z) {
        this.clientXVelocity = x;
        this.clientYVelocity = y;
        this.clientZVelocity = z;
        this.method_18800(this.clientXVelocity, this.clientYVelocity, this.clientZVelocity);
    }

    public void method_5773() {
        this.previousYaw = this.method_36454();
        super.method_5773();
        this.updatePositionAndRotation();
        this.doMovement();
        this.slowDown();
        this.doGravity();
        this.method_5784(class_1313.field_6308, this.method_18798());
        this.method_5852();
        this.tryInsertingIntoTank();
    }

    public void doMovement() {
        this.method_36457(0.0f);
        class_243 movement = this.method_5631(this.method_36455(), this.method_36454());
        double yVelocity = this.method_18798().method_10214();
        this.method_18799(this.method_18798().method_1031(movement.method_10216(), 0.0, movement.method_10215()).method_1021((double)this.getSpeed()));
        this.method_18799(new class_243(this.method_18798().method_10216(), yVelocity, this.method_18798().method_10215()));
    }

    public void slowDown() {
        this.setSpeed(this.getSpeed() / 1.05f);
        if ((double)this.getSpeed() < 0.001 && (double)this.getSpeed() > -0.001) {
            this.setSpeed(0.0f);
        }
        this.setSpeed(class_3532.method_15363((float)this.getSpeed(), (float)this.getMinSpeed(), (float)this.getMaxSpeed()));
    }

    public float getMinSpeed() {
        return -0.2f;
    }

    public float getMaxSpeed() {
        return 0.4f;
    }

    public void doGravity() {
        if (!this.method_37908().method_22340(this.method_24515())) {
            return;
        }
        if (!this.method_5740()) {
            if (this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, -1.0E-4, 0.0));
            } else {
                this.method_18799(this.method_18798().method_1031(0.0, -0.03, 0.0));
            }
            if (this.method_18798().method_10214() < VehiclesConfig.gravity) {
                this.method_18799(new class_243(this.method_18798().method_10216(), VehiclesConfig.gravity, this.method_18798().method_10215()));
            }
        }
    }

    public float getSpeed() {
        return ((Float)this.field_6011.method_12789(SPEED)).floatValue();
    }

    public void setSpeed(float value) {
        this.field_6011.method_12778(SPEED, (Object)Float.valueOf(value));
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.method_37908().field_9236) {
            if (this.method_5685().size() > this.getMaxPassengers()) {
                return class_1269.field_5811;
            }
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public void openInventory(class_1657 player) {
        this.openInventory(player, new VehicleScreenMenuProvider(this));
    }

    public void openInventory(class_1657 player, ExtraDataMenuProvider handler) {
        if (!player.method_37908().field_9236 && player.method_5715()) {
            MenuHooks.openMenu((class_3222)((class_3222)player), (ExtraDataMenuProvider)handler);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972;
        if (amount > 0.0f && (class_12972 = source.method_5529()) instanceof class_1657 && !((player = (class_1657)class_12972).method_5854() instanceof Vehicle)) {
            this.drop();
            return true;
        }
        return false;
    }

    public void drop() {
        if (this.method_37908().method_8450().method_8355(class_1928.field_19392)) {
            class_2338 pos = this.method_24515();
            if (!this.getDropStack().method_7960()) {
                ItemStackHolder dropStack = new ItemStackHolder(this.getDropStack());
                ((VehicleItem)dropStack.getStack().method_7909()).insert(dropStack, this.getTankHolder());
                class_2487 nbt = dropStack.getStack().method_7948();
                nbt.method_10566("Inventory", (class_2520)this.inventory.method_7660());
                this.method_37908().method_8396(null, pos, class_3417.field_21919, class_3419.field_15245, 1.0f, 1.0f);
                this.method_37908().method_8649((class_1297)new class_1542(this.method_37908(), (double)pos.method_10263(), (double)((float)pos.method_10264() + 0.5f), (double)pos.method_10260(), dropStack.getStack()));
            }
        }
        if (!this.method_37908().field_9236) {
            this.method_31472();
        }
    }

    public void explode(float powerMultiplier) {
        if (!this.method_37908().field_9236) {
            this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 7.0f * powerMultiplier, OxygenUtils.levelHasOxygen(this.method_37908()), class_1937.class_7867.field_40891);
        }
        this.method_31472();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (this.method_18798().method_10214() < VehiclesConfig.fallingExplosionThreshold && this.method_24828()) {
            this.explode(VehiclesConfig.fallingExplosionMultiplier);
            return true;
        }
        return false;
    }

    public class_1799 getDropStack() {
        return class_1799.field_8037;
    }

    public class_1309 method_5642() {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            return entity;
        }
        return super.method_5642();
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return 1;
    }

    public double method_5621() {
        return 0.0;
    }

    public boolean shouldSit() {
        return true;
    }

    public boolean shouldRenderPlayer() {
        return true;
    }

    public boolean doHighFov() {
        return false;
    }

    public boolean fullyConcealsRider() {
        return false;
    }

    public boolean canRiderTakeFallDamage() {
        return true;
    }

    public boolean renderPlanetBar() {
        return false;
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948() {
        return true;
    }

    public long getTankSize() {
        return 0L;
    }

    public long getFuelPerTick() {
        return 0L;
    }

    public CustomInventory getInventory() {
        return this.inventory;
    }

    public abstract int getInventorySize();

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void tryInsertingIntoTank() {
        if (this.getInventorySize() > 1 && !this.getInventory().method_5438(0).method_7960() && !this.method_37908().field_9236) {
            FluidUtils.insertItemFluidToTank((FluidContainer)this.tank, (class_1263)this.getInventory(), 0, 1, 0, f -> f.method_15791(ModTags.FUELS));
            FluidUtils.extractTankFluidToItem((FluidContainer)this.tank, (class_1263)this.getInventory(), 0, 1, 0, f -> true);
        }
    }

    public SimpleFluidContainer getTank() {
        return this.tank;
    }

    public FluidHolder getTankHolder() {
        return (FluidHolder)this.tank.getFluids().get(0);
    }

    public long getTankAmount() {
        return this.getTankHolder().getFluidAmount();
    }

    public class_3611 getTankFluid() {
        return this.getTankHolder().getFluid();
    }

    public void consumeFuel() {
        if (this.method_37908().method_8510() % 20L == 0L) {
            this.getTank().extractFluid(FluidHooks.newFluidHolder((class_3611)this.getTankFluid(), (long)this.getFuelPerTick(), null), false);
        }
    }
}

