/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client;

import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.ad_astra.client.registry.ClientModEntities;
import earth.terrarium.ad_astra.client.registry.ClientModKeybindings;
import earth.terrarium.ad_astra.client.registry.ClientModScreens;
import earth.terrarium.ad_astra.client.renderer.armor.ArmourRenderers;
import earth.terrarium.ad_astra.client.renderer.block.ChestItemRenderer;
import earth.terrarium.ad_astra.client.renderer.block.EnergizerBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.SlidingDoorBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagBlockEntityRenderer;
import earth.terrarium.ad_astra.client.renderer.block.flag.FlagItemRenderer;
import earth.terrarium.ad_astra.client.renderer.block.globe.GlobeRenderer;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_1.RocketItemRendererTier1;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_2.RocketItemRendererTier2;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_3.RocketItemRendererTier3;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rocket.tier_4.RocketItemRendererTier4;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rover.RoverItemRenderer;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetResources;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.PlanetSkyRenderer;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import earth.terrarium.ad_astra.client.screen.PlayerOverlayScreen;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.botarium.client.ClientHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_1723;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_326;
import net.minecraft.class_3302;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4057;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_756;
import net.minecraft.class_777;
import net.minecraft.class_826;
import net.minecraft.class_837;
import org.apache.logging.log4j.util.TriConsumer;

public class AdAstraClient {
    public static boolean hasUpdatedPlanets;
    public static List<SolarSystem> solarSystems;
    public static List<PlanetSkyRenderer> skyRenderers;
    public static List<PlanetRing> planetRings;
    public static List<Galaxy> galaxies;

    public static void init() {
        ClientModScreens.init();
        ClientModKeybindings.init();
        ArmourRenderers.init();
        ClientModEntities.registerEntityRenderers();
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.FLAG.get()), FlagBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.GLOBE.get()), GlobeRenderer::new);
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.ENERGIZER.get()), EnergizerBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.SLIDING_DOOR.get()), SlidingDoorBlockEntityRenderer::new);
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.SIGN.get()), class_837::new);
        ClientHooks.registerBlockEntityRenderers((class_2591)((class_2591)ModBlockEntityTypes.CHEST.get()), class_826::new);
        class_4722.field_21712.put(ModBlocks.GLACIAN_SIGN_TYPE, new class_4730(class_4722.field_21708, new class_2960("ad_astra", "entity/signs/glacian")));
    }

    public static void onRegisterHud(Consumer<RenderHud> register) {
        register.accept(PlayerOverlayScreen::render);
    }

    public static void onRegisterFluidRenderTypes(TriConsumer<class_1921, class_3611, class_3611> register) {
        register.accept((Object)class_1921.method_23583(), (Object)((class_3611)ModFluids.FUEL.get()), (Object)((class_3611)ModFluids.FLOWING_FUEL.get()));
        register.accept((Object)class_1921.method_23583(), (Object)((class_3611)ModFluids.CRYO_FUEL.get()), (Object)((class_3611)ModFluids.FLOWING_CRYO_FUEL.get()));
        register.accept((Object)class_1921.method_23583(), (Object)((class_3611)ModFluids.OIL.get()), (Object)((class_3611)ModFluids.FLOWING_OIL.get()));
        register.accept((Object)class_1921.method_23583(), (Object)((class_3611)ModFluids.OXYGEN.get()), (Object)((class_3611)ModFluids.FLOWING_OXYGEN.get()));
    }

    public static void onRegisterBlockRenderTypes(BiConsumer<class_1921, List<class_2248>> register) {
        ClientHooks.setRenderLayer((class_2248)((class_2248)ModBlocks.VENT.get()), (class_1921)class_1921.method_23581());
        ModBlocks.GLOBES.stream().forEach(block -> register.accept(class_1921.method_23581(), List.of((class_2248)block.get())));
        register.accept(class_1921.method_23581(), List.of((class_2248)ModBlocks.WATER_PUMP.get(), (class_2248)ModBlocks.ENERGIZER.get(), (class_2248)ModBlocks.STEEL_DOOR.get(), (class_2248)ModBlocks.STEEL_TRAPDOOR.get(), (class_2248)ModBlocks.GLACIAN_DOOR.get(), (class_2248)ModBlocks.GLACIAN_TRAPDOOR.get(), (class_2248)ModBlocks.AERONOS_DOOR.get(), (class_2248)ModBlocks.AERONOS_TRAPDOOR.get(), (class_2248)ModBlocks.STROPHAR_DOOR.get(), (class_2248)ModBlocks.STROPHAR_TRAPDOOR.get(), (class_2248)ModBlocks.EXTINGUISHED_TORCH.get(), (class_2248)ModBlocks.WALL_EXTINGUISHED_TORCH.get(), (class_2248)ModBlocks.EXTINGUISHED_LANTERN.get(), (class_2248)ModBlocks.GLACIAN_LEAVES.get(), (class_2248)ModBlocks.NASA_WORKBENCH.get(), (class_2248)ModBlocks.AERONOS_MUSHROOM.get(), (class_2248)ModBlocks.STROPHAR_MUSHROOM.get(), (class_2248)ModBlocks.AERONOS_LADDER.get(), (class_2248)ModBlocks.STROPHAR_LADDER.get(), (class_2248)ModBlocks.AERONOS_CHEST.get(), (class_2248)ModBlocks.STROPHAR_CHEST.get()));
    }

    public static void onRegisterItemRenderers(BiConsumer<class_1935, class_756> register) {
        register.accept((class_1935)ModItems.TIER_1_ROCKET.get(), new RocketItemRendererTier1());
        register.accept((class_1935)ModItems.TIER_2_ROCKET.get(), new RocketItemRendererTier2());
        register.accept((class_1935)ModItems.TIER_3_ROCKET.get(), new RocketItemRendererTier3());
        register.accept((class_1935)ModItems.TIER_4_ROCKET.get(), new RocketItemRendererTier4());
        register.accept((class_1935)ModItems.TIER_1_ROVER.get(), new RoverItemRenderer());
        register.accept((class_1935)ModBlocks.AERONOS_CHEST.get(), new ChestItemRenderer((class_2248)ModBlocks.AERONOS_CHEST.get()));
        register.accept((class_1935)ModBlocks.STROPHAR_CHEST.get(), new ChestItemRenderer((class_2248)ModBlocks.STROPHAR_CHEST.get()));
        ModItems.GLOBES.stream().forEach(item -> register.accept((class_1935)item.get(), new GlobeRenderer.ItemRenderer()));
        ModItems.FLAGS.stream().forEach(item -> register.accept((class_1935)item.get(), new FlagItemRenderer()));
    }

    public static void onRegisterReloadListeners(BiConsumer<class_2960, class_3302> registry) {
        registry.accept(new class_2960("ad_astra", "planet_resources"), (class_3302)new PlanetResources());
    }

    public static void onRegisterModels(Consumer<class_2960> register) {
        ModBlocks.GLOBES.stream().forEach(b -> register.accept(new class_2960("ad_astra", "block/" + b.getId().method_12832() + "_cube")));
        ModBlocks.FLAGS.stream().forEach(block -> register.accept(new class_2960("ad_astra", "block/flag/" + block.getId().method_12832())));
        ModBlocks.SLIDING_DOORS.stream().forEach(block -> register.accept(new class_2960("ad_astra", "block/door/" + block.getId().method_12832())));
        ModBlocks.SLIDING_DOORS.stream().forEach(block -> register.accept(new class_2960("ad_astra", "block/door/" + block.getId().method_12832() + "_flipped")));
    }

    public static void renderBlock(class_2960 model, class_4587 poseStack, class_4597 buffer, int packedLight, int packedOverlay) {
        class_310 minecraft = class_310.method_1551();
        class_1092 manager = minecraft.method_1554();
        class_1087 baked = ClientPlatformUtils.getModel(manager, model);
        class_4588 vertexConsumer1 = buffer.getBuffer(class_1921.method_23576((class_2960)class_1723.field_21668));
        List quads1 = baked.method_4707(null, null, minecraft.field_1687.field_9229);
        class_4587.class_4665 entry1 = poseStack.method_23760();
        for (class_777 quad : quads1) {
            vertexConsumer1.method_22919(entry1, quad, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
    }

    public static void onAddItemColors(BiConsumer<class_326, class_1935[]> register) {
        register.accept((itemStack, i) -> i > 0 ? -1 : ((class_4057)itemStack.method_7909()).method_7800(itemStack), new class_1935[]{(class_1935)ModItems.SPACE_HELMET.get(), (class_1935)ModItems.SPACE_SUIT.get(), (class_1935)ModItems.SPACE_PANTS.get(), (class_1935)ModItems.SPACE_BOOTS.get()});
        register.accept((itemStack, i) -> i > 0 ? -1 : ((class_4057)itemStack.method_7909()).method_7800(itemStack), new class_1935[]{(class_1935)ModItems.NETHERITE_SPACE_HELMET.get(), (class_1935)ModItems.NETHERITE_SPACE_SUIT.get(), (class_1935)ModItems.NETHERITE_SPACE_PANTS.get(), (class_1935)ModItems.NETHERITE_SPACE_BOOTS.get()});
        register.accept((itemStack, i) -> i > 0 ? -1 : ((class_4057)itemStack.method_7909()).method_7800(itemStack), new class_1935[]{(class_1935)ModItems.JET_SUIT_HELMET.get(), (class_1935)ModItems.JET_SUIT.get(), (class_1935)ModItems.JET_SUIT_PANTS.get(), (class_1935)ModItems.JET_SUIT_BOOTS.get()});
    }

    static {
        solarSystems = new ArrayList<SolarSystem>();
        skyRenderers = new ArrayList<PlanetSkyRenderer>();
        planetRings = new ArrayList<PlanetRing>();
        galaxies = new ArrayList<Galaxy>();
    }

    @FunctionalInterface
    public static interface RenderHud {
        public void renderHud(class_332 var1, float var2);
    }
}

