/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.event;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.chunk.IPlayerDataPlayer;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_3194;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_8563;
import net.minecraft.server.MinecraftServer;

public class EventHandler {
    private static ArrayDeque<ChunkInfo> delayedLoading = new ArrayDeque();
    private static Map<class_1923, ChunkInfo> delayedLoadingMap = new HashMap<class_1923, ChunkInfo>();
    private static List<ChunkInfo> toadd = new ArrayList<ChunkInfo>();
    static Map<class_1923, Integer> recentlyLoadedTimes = new HashMap<class_1923, Integer>();
    static Map<class_1923, Integer> recentlyUnLoadedTimes = new HashMap<class_1923, Integer>();

    public static void addChunkToQueue(ChunkInfo info) {
        if (info.level.method_8503() != null && !info.level.method_8503().method_18854()) {
            info.level.method_8503().method_20493(() -> EventHandler.addChunkToQueue(info));
        } else {
            if (BetterChunkLoading.IN_DEV && delayedLoadingMap.containsKey(info.pos)) {
                BetterChunkLoading.LOGGER.error("processing chunk twice!", (Throwable)new Exception());
            }
            toadd.add(info);
        }
    }

    public static void onServerTick(MinecraftServer server) {
        long serverTime = server.method_3780();
        for (ChunkInfo info : toadd) {
            delayedLoadingMap.put(info.pos, info);
            delayedLoading.offer(info);
        }
        if (!toadd.isEmpty()) {
            toadd = new ArrayList<ChunkInfo>();
        }
        int amount = 0;
        Iterator<ChunkInfo> iterator = delayedLoading.iterator();
        while (iterator.hasNext()) {
            ChunkInfo chunkInfo = iterator.next();
            if (serverTime - chunkInfo.originalTime > 20L && chunkInfo.level.method_8393(chunkInfo.pos.field_9181, chunkInfo.pos.field_9180) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 + 1, chunkInfo.pos.field_9180 + 1) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 + 1, chunkInfo.pos.field_9180) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 + 1, chunkInfo.pos.field_9180 - 1) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181, chunkInfo.pos.field_9180 + 1) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181, chunkInfo.pos.field_9180 - 1) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 - 1, chunkInfo.pos.field_9180 + 1) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 - 1, chunkInfo.pos.field_9180) && chunkInfo.level.method_8393(chunkInfo.pos.field_9181 - 1, chunkInfo.pos.field_9180 - 1)) {
                EventHandler.applyToChunk(chunkInfo);
                delayedLoadingMap.remove(chunkInfo.pos);
                iterator.remove();
                if (++amount <= 20) continue;
                return;
            }
            if (serverTime - chunkInfo.originalTime <= 1200L) break;
            if (BetterChunkLoading.IN_DEV && ((class_3218)chunkInfo.level).method_14178().field_17252.field_13895.get(chunkInfo.pos.method_8324()) == null) {
                BetterChunkLoading.LOGGER.warn("Missing ticket!!!");
                ((class_3218)chunkInfo.level).method_14178().field_17252.method_15892(((class_3218)chunkInfo.level).method_14178().field_17254);
                if (((class_3218)chunkInfo.level).method_14178().field_17252.field_13895.get(chunkInfo.pos.method_8324()) == null) {
                    BetterChunkLoading.LOGGER.warn("Really! Missing ticket!!! time since ticket:" + ((long)chunkInfo.level.method_8503().method_3780() - chunkInfo.originalTime));
                }
            }
            EventHandler.applyToChunk(chunkInfo);
            iterator.remove();
            delayedLoadingMap.remove(chunkInfo.pos);
            return;
        }
    }

    private static void applyToChunk(ChunkInfo chunkInfo) {
        class_2818 chunk = chunkInfo.level.method_8497(chunkInfo.pos.field_9181, chunkInfo.pos.field_9180);
        for (int i = 0; i < chunkInfo.data.length; ++i) {
            if (chunkInfo.data[i] == null) continue;
            for (Short oshort : chunkInfo.data[i]) {
                class_2338 blockpos = class_2839.method_12314((short)oshort, (int)chunk.method_31604(i), (class_1923)chunkInfo.pos);
                class_2680 blockstate = chunk.method_8320(blockpos);
                class_3610 fluidstate = blockstate.method_26227();
                if (!fluidstate.method_15769()) {
                    fluidstate.method_15770(chunkInfo.level, blockpos);
                }
                if (blockstate.method_26204() instanceof class_2404) continue;
                class_2680 blockstate1 = class_2248.method_9510((class_2680)blockstate, (class_1936)chunkInfo.level, (class_2338)blockpos);
                chunkInfo.level.method_8652(blockpos, blockstate1, 20);
            }
        }
        ((class_3215)chunkInfo.level.method_8398()).field_17252.method_20444(BetterChunkLoading.TICKET_POST_PROCESS, chunkInfo.pos, class_8563.method_51828((class_3194)class_3194.field_44855) - 1, (Object)chunkInfo.pos);
    }

    public static void onPlayerTick(class_3222 player) {
        if (player.field_6012 % 3 == 0 && player instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            if (player.getClass() == class_3222.class) {
                dataPlayer.betterchunkloading$getPlayerChunkData().onChunkChanged(player);
            }
        }
    }

    public static void onPlayerLogout(class_3222 player) {
        if (player instanceof IPlayerDataPlayer) {
            IPlayerDataPlayer dataPlayer = (IPlayerDataPlayer)player;
            dataPlayer.betterchunkloading$getPlayerChunkData().onLogout(player);
        }
    }

    public static void onChunkLoad(class_3218 level, class_2818 chunk) {
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        boolean sr = false;
        sr |= level.method_8393(chunk.method_12004().field_9181 + 1, chunk.method_12004().field_9180);
        sr |= level.method_8393(chunk.method_12004().field_9181, chunk.method_12004().field_9180 + 1);
        sr |= level.method_8393(chunk.method_12004().field_9181 - 1, chunk.method_12004().field_9180);
        if (!(sr |= level.method_8393(chunk.method_12004().field_9181, chunk.method_12004().field_9180 - 1))) {
            BetterChunkLoading.LOGGER.warn("no surrounding chunk!");
        }
        recentlyLoadedTimes.put(chunk.method_12004(), level.method_8503().method_3780());
        if (recentlyUnLoadedTimes.containsKey(chunk.method_12004()) && level.method_8503().method_3780() - recentlyUnLoadedTimes.get(chunk.method_12004()) < 100) {
            BetterChunkLoading.LOGGER.warn("Loaded shortly after unload:" + chunk.method_12004());
        }
    }

    public static void onChunkUnLoad(class_3218 level, class_2818 chunk) {
        if (!BetterChunkLoading.IN_DEV) {
            return;
        }
        recentlyUnLoadedTimes.put(chunk.method_12004(), level.method_8503().method_3780());
        if (recentlyLoadedTimes.containsKey(chunk.method_12004()) && level.method_8503().method_3780() - recentlyLoadedTimes.get(chunk.method_12004()) < 100) {
            BetterChunkLoading.LOGGER.warn("UnLoaded shortly after load:" + chunk.method_12004());
        }
    }

    public static class ChunkInfo {
        private final long originalTime;
        private final class_1923 pos;
        private final class_1937 level;
        private final ShortList[] data;

        public ChunkInfo(long originalTime, class_1923 pos, class_1937 level, ShortList[] data) {
            this.originalTime = originalTime;
            this.pos = pos;
            this.level = level;
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkInfo chunkInfo = (ChunkInfo)o;
            return Objects.equals(this.pos, chunkInfo.pos);
        }

        public int hashCode() {
            return Objects.hash(this.pos);
        }
    }
}

