/*
 * Decompiled with CFR 0.152.
 */
package common.net.jason13.enderpack.core.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import common.net.jason13.enderpack.CommonClient;
import common.net.jason13.enderpack.core.player.CommonBagModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class EnderPackBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    final double ONE_SIXTEENTH = 0.0625;
    private final ModelPart enderpack;

    public EnderPackBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(CommonClient.ENDERPACK_LAYER);
        this.enderpack = root.getChild("enderpack");
    }

    public void render(T blockEntity, float partialTick, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state;
        boolean hasLevel;
        Level level = blockEntity.getLevel();
        boolean bl = hasLevel = level != null;
        if (hasLevel && (state = blockEntity.getBlockState()).hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            pose.pushPose();
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Vector3f offset = new Vector3f();
            float rotationDegrees = 0.0f;
            switch (facing) {
                case NORTH: {
                    offset.set(1.0f, 0.125f, 1.0f);
                    rotationDegrees = 180.0f;
                    break;
                }
                case EAST: {
                    offset.set(0.0f, 0.125f, 1.0f);
                    rotationDegrees = 90.0f;
                    break;
                }
                case SOUTH: {
                    offset.set(0.0f, 0.125f, 0.0f);
                    break;
                }
                case WEST: {
                    offset.set(1.0f, 0.125f, 0.0f);
                    rotationDegrees = 270.0f;
                }
            }
            pose.translate(offset.x, offset.y, offset.z);
            pose.mulPose(Axis.YP.rotationDegrees(rotationDegrees));
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)CommonBagModel.ENDERPACK_TEXTURE));
            pose.translate(0.5, 0.3125, 0.5625);
            pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
            this.enderpack.render(pose, vertexConsumer, packedLight, packedOverlay);
            pose.popPose();
        }
    }
}

