/*
 * Decompiled with CFR 0.152.
 */
package forge.net.jason13.automessage.capability;

import forge.net.jason13.automessage.config.Config;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class MessagingCapability {
    private int playtime = 0;
    private int[] softCounts = new int[((List)Config.MESSAGES.get()).size()];
    private int[] hardCounts = new int[((List)Config.MESSAGES.get()).size()];

    public int getPlaytime() {
        return this.playtime;
    }

    public int[] getSoftCounts() {
        return this.softCounts;
    }

    public int[] getHardCounts() {
        return this.hardCounts;
    }

    public void incrementPlaytime() {
        ++this.playtime;
    }

    public void incrementSoftCountAtIndex(int index) {
        int n = index;
        this.softCounts[n] = this.softCounts[n] + 1;
    }

    public void incrementHardCountAtIndex(int index) {
        int n = index;
        this.hardCounts[n] = this.hardCounts[n] + 1;
    }

    public void resetSoftCounts() {
        for (int i = 0; i < this.softCounts.length; ++i) {
            this.softCounts[i] = 0;
        }
    }

    public void copyOnDeath(MessagingCapability source) {
        this.playtime = source.playtime;
        this.softCounts = source.softCounts;
        this.hardCounts = source.hardCounts;
    }

    public void copyFrom(MessagingCapability source) {
        this.playtime = source.playtime;
        this.softCounts = source.softCounts;
        this.hardCounts = source.hardCounts;
    }

    public void saveNBTData(CompoundTag nbt) {
        nbt.m_128405_("playtime", this.playtime);
        nbt.m_128385_("soft_counts", this.softCounts);
        nbt.m_128385_("hard_counts", this.hardCounts);
    }

    public void loadNBTData(CompoundTag nbt) {
        this.playtime = nbt.m_128451_("playtime");
        this.softCounts = nbt.m_128465_("soft_counts");
        this.hardCounts = nbt.m_128465_("hard_counts");
    }
}

