/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.jason13.automessage.util;

import fabric.net.jason13.automessage.FabricExampleMod;
import fabric.net.jason13.automessage.networking.ModMessages;
import fabric.net.jason13.automessage.util.IEntityDataSaver;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlayerCountersData {
    public static void initializeValuesIfAbsent(IEntityDataSaver player) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("playtime")) {
            nbt.method_10569("playtime", 0);
        }
        if (!nbt.method_10545("soft")) {
            nbt.method_10539("soft", new int[FabricExampleMod.messages.size()]);
        }
        if (!nbt.method_10545("hard")) {
            nbt.method_10539("hard", new int[FabricExampleMod.messages.size()]);
        }
    }

    public static void incrementPlaytime(IEntityDataSaver player) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("playtime")) {
            nbt.method_10569("playtime", 0);
        }
        int time = nbt.method_10550("playtime");
        nbt.method_10569("playtime", ++time);
    }

    public static int[] addSoftCounterAtIndex(IEntityDataSaver player, int index) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("soft")) {
            nbt.method_10539("soft", new int[FabricExampleMod.messages.size()]);
        }
        int[] values = nbt.method_10561("soft");
        int n = index;
        values[n] = values[n] + 1;
        return values;
    }

    public static int[] addHardCounterAtIndex(IEntityDataSaver player, int index) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("hard")) {
            nbt.method_10539("hard", new int[FabricExampleMod.messages.size()]);
        }
        int[] values = nbt.method_10561("hard");
        int n = index;
        values[n] = values[n] + 1;
        return values;
    }

    public static int[] resetSoftCounters(IEntityDataSaver player) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("soft")) {
            nbt.method_10539("soft", new int[FabricExampleMod.messages.size()]);
        }
        int[] values = nbt.method_10561("soft");
        int[] resetSoft = new int[values.length];
        return resetSoft;
    }

    public static int getSoftCounterAtIndex(IEntityDataSaver player, int index) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("soft")) {
            nbt.method_10539("soft", new int[FabricExampleMod.messages.size()]);
        }
        int[] values = nbt.method_10561("soft");
        return values[index];
    }

    public static int getHardCounterAtIndex(IEntityDataSaver player, int index) {
        class_2487 nbt = player.getPersistentData();
        if (!nbt.method_10545("hard")) {
            nbt.method_10539("hard", new int[FabricExampleMod.messages.size()]);
        }
        int[] values = nbt.method_10561("hard");
        return values[index];
    }

    public static void syncSoftCounters(int[] softCounts, class_3222 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10806(softCounts);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.COUNTERS_SYNC_ID, (class_2540)buffer);
    }

    public static void syncHardCounters(int[] hardCounts, class_3222 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.method_10806(hardCounts);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.COUNTERS_SYNC_ID, (class_2540)buffer);
    }

    public static void syncValue(int value, class_3222 player) {
        class_2540 buffer = PacketByteBufs.create();
        buffer.writeInt(value);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ModMessages.COUNTERS_SYNC_ID, (class_2540)buffer);
    }
}

