/*
 * Decompiled with CFR 0.152.
 */
package common.net.jason13.stackablestewandsoup.mixin;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={SuspiciousStewItem.class})
public class CommonSuspiciousStewItemMixin {
    @Overwrite
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, itemStack);
        }
        if (itemStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.BOWL);
        }
        if (livingEntity instanceof Player && !((Player)livingEntity).getAbilities().instabuild) {
            livingEntity.eat(level, itemStack);
            Objects.requireNonNull(livingEntity);
            CommonSuspiciousStewItemMixin.listPotionEffectsOld(itemStack, arg_0 -> ((LivingEntity)livingEntity).addEffect(arg_0));
            ItemStack itemstack = new ItemStack((ItemLike)Items.BOWL);
            Player player = (Player)livingEntity;
            if (!player.getInventory().add(itemstack)) {
                player.drop(itemstack, false);
            }
        }
        return itemStack;
    }

    private static void listPotionEffectsOld(ItemStack $$0, Consumer<MobEffectInstance> $$1) {
        CompoundTag $$2 = $$0.getTag();
        if ($$2 != null && $$2.contains("Effects", 9)) {
            ListTag $$3 = $$2.getList("Effects", 10);
            for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
                CompoundTag $$5 = $$3.getCompound($$4);
                int $$7 = $$5.contains("EffectDuration", 99) ? $$5.getInt("EffectDuration") : 160;
                MobEffect $$8 = MobEffect.byId((int)$$5.getInt("EffectId"));
                if ($$8 == null) continue;
                $$1.accept(new MobEffectInstance($$8, $$7));
            }
        }
    }
}

