/*
 * Decompiled with CFR 0.152.
 */
package common.com.lupin.dangerclose;

import common.com.lupin.dangerclose.CommonConstants;
import common.com.lupin.dangerclose.util.CommonConfigIO;
import java.io.File;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;

public class CommonClass {
    public static Boolean TORCHES_BURN;
    public static Boolean SOUL_TORCHES_BURN;
    public static Boolean CAMPFIRES_BURN;
    public static Boolean SOUL_CAMPFIRES_BURN;
    public static Boolean STONECUTTERS_CUT;
    public static Boolean ENABLE_BLAZE_DAMAGE;
    public static Boolean ENABLE_MAGMA_CUBE_DAMAGE;
    public static Boolean ENABLE_MAGMA_BLOCK_DAMAGE;
    public static Boolean ENABLE_DANGER_CLOSE;
    public static final TagKey<Block> TORCH_BURN_DANGER;
    public static final TagKey<Block> SOUL_TORCH_BURN_DANGER;
    public static final TagKey<Block> CAMPFIRE_BURN_DANGER;
    public static final TagKey<Block> SOUL_CAMPFIRE_BURN_DANGER;
    public static final TagKey<Block> MAGMA_BURN_DANGER;
    public static final TagKey<Block> STONECUTTER_DANGER;

    public static void init() {
        if (new File("config/dangerclose.properties").isFile()) {
            CommonConstants.LOG.info("config/dangerclose.properties was discovered!");
            Map<String, Boolean> LOADED_CONFIG = CommonConfigIO.readConfigurationFromFile();
            for (Map.Entry<String, Boolean> pair : LOADED_CONFIG.entrySet()) {
                switch (pair.getKey()) {
                    case "TORCHES_BURN": {
                        TORCHES_BURN = pair.getValue();
                        break;
                    }
                    case "SOUL_TORCHES_BURN": {
                        SOUL_TORCHES_BURN = pair.getValue();
                        break;
                    }
                    case "CAMPFIRES_BURN": {
                        CAMPFIRES_BURN = pair.getValue();
                        break;
                    }
                    case "SOUL_CAMPFIRES_BURN": {
                        SOUL_CAMPFIRES_BURN = pair.getValue();
                        break;
                    }
                    case "STONECUTTERS_CUT": {
                        STONECUTTERS_CUT = pair.getValue();
                        break;
                    }
                    case "ENABLE_BLAZE_DAMAGE": {
                        ENABLE_BLAZE_DAMAGE = pair.getValue();
                        break;
                    }
                    case "ENABLE_MAGMA_CUBE_DAMAGE": {
                        ENABLE_MAGMA_CUBE_DAMAGE = pair.getValue();
                        break;
                    }
                    case "ENABLE_MAGMA_BLOCK_DAMAGE": {
                        ENABLE_MAGMA_BLOCK_DAMAGE = pair.getValue();
                        break;
                    }
                    case "ENABLE_DANGER_CLOSE": {
                        ENABLE_DANGER_CLOSE = pair.getValue();
                    }
                }
            }
        } else {
            CommonConstants.LOG.info("config/dangerclose.properties was not found!");
            CommonConstants.LOG.info("Setting configuration values to default, and initializing the configuration file!");
            CommonClass.blurb();
            TORCHES_BURN = false;
            SOUL_TORCHES_BURN = false;
            CAMPFIRES_BURN = true;
            SOUL_CAMPFIRES_BURN = true;
            STONECUTTERS_CUT = true;
            ENABLE_BLAZE_DAMAGE = true;
            ENABLE_MAGMA_CUBE_DAMAGE = false;
            ENABLE_MAGMA_BLOCK_DAMAGE = true;
            ENABLE_DANGER_CLOSE = true;
            CommonConfigIO.initializeConfiguration();
        }
    }

    private static void blurb() {
        CommonConstants.LOG.info("TORCHES_BURN set to false!");
        CommonConstants.LOG.info("SOUL_TORCHES_BURN set to false!");
        CommonConstants.LOG.info("CAMPFIRES_BURN set to true!");
        CommonConstants.LOG.info("SOUL_CAMPFIRES_BURN set to true!");
        CommonConstants.LOG.info("STONECUTTERS_CUT set to true!");
        CommonConstants.LOG.info("ENABLE_BLAZE_DAMAGE set to true!");
        CommonConstants.LOG.info("ENABLE_MAGMA_CUBE_DAMAGE set to false!");
        CommonConstants.LOG.info("ENABLE_MAGMA_BLOCK_DAMAGE set to true!");
        CommonConstants.LOG.info("ENABLE_DANGER_CLOSE set to true!");
    }

    static {
        TORCH_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "torch_burn_danger"));
        SOUL_TORCH_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "soul_torch_burn_danger"));
        CAMPFIRE_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "campfire_burn_danger"));
        SOUL_CAMPFIRE_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "soul_campfire_burn_danger"));
        MAGMA_BURN_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "magma_burn_danger"));
        STONECUTTER_DANGER = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("dangerclose", "stonecutter_danger"));
    }
}

