/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFSounds;
import twilightforest.init.TFStructures;
import twilightforest.util.PlayerHelper;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.util.StructureHints;

public class TFGenerationSettings {
    private static final Map<ResourceLocation, ResourceLocation[]> BIOME_ADVANCEMENTS = new HashMap<ResourceLocation, ResourceLocation[]>();
    private static final Map<ResourceLocation, BiConsumer<Player, ServerLevel>> BIOME_PROGRESSION_ENFORCEMENT = new HashMap<ResourceLocation, BiConsumer<Player, ServerLevel>>();
    @Deprecated
    public static final int SEALEVEL = 0;
    public static final ResourceLocation DIMENSION;
    public static final ResourceKey<LevelStem> WORLDGEN_KEY;
    public static final ResourceKey<Level> DIMENSION_KEY;

    private static void registerBiomeAdvancementRestriction(ResourceKey<Biome> biome, ResourceLocation ... advancements) {
        BIOME_ADVANCEMENTS.put(biome.m_135782_(), advancements);
    }

    private static void registerBiomeProgressionEnforcement(ResourceKey<Biome> biome, BiConsumer<Player, ServerLevel> exec) {
        BIOME_PROGRESSION_ENFORCEMENT.put(biome.m_135782_(), exec);
    }

    public static void enforceBiomeProgression(Player player, ServerLevel level) {
        Biome currentBiome = (Biome)level.m_204166_(player.m_20183_()).m_203334_();
        if (TFGenerationSettings.isBiomeSafeFor(currentBiome, (Entity)player)) {
            return;
        }
        BiConsumer<Player, ServerLevel> exec = BIOME_PROGRESSION_ENFORCEMENT.get(level.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)currentBiome));
        if (exec != null) {
            exec.accept(player, level);
        }
    }

    public static boolean isTwilightPortalDestination(Level level) {
        return DIMENSION.equals((Object)level.m_46472_().m_135782_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isTwilightWorldOnClient(Level level) {
        return "twilightforest".equals(Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().m_135827_()) || TFGenerationSettings.isTwilightPortalDestination(level);
    }

    public static boolean usesTwilightChunkGenerator(ServerLevel level) {
        return level.m_7726_().m_8481_() instanceof ChunkGeneratorTwilight;
    }

    public static boolean isBiomeSafeFor(Biome biome, Entity entity) {
        ResourceLocation[] advancements = BIOME_ADVANCEMENTS.get(entity.m_9236_().m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome));
        if (advancements != null && entity instanceof Player) {
            return PlayerHelper.doesPlayerHaveRequiredAdvancements((Player)entity, advancements);
        }
        return true;
    }

    static {
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.DARK_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.DARK_FOREST_CENTER, TwilightForestMod.prefix("progress_knights"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.FINAL_PLATEAU, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.FIRE_SWAMP, TwilightForestMod.prefix("progress_labyrinth"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.GLACIER, TwilightForestMod.prefix("progress_yeti"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.HIGHLANDS, TwilightForestMod.prefix("progress_merge"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.SNOWY_FOREST, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.SWAMP, TwilightForestMod.prefix("progress_lich"));
        TFGenerationSettings.registerBiomeAdvancementRestriction(TFBiomes.THORNLANDS, TwilightForestMod.prefix("progress_troll"));
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.DARK_FOREST, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, true));
                StructureHints.tryHintForStructure(player, level, TFStructures.KNIGHT_STRONGHOLD);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.DARK_FOREST_CENTER, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 200, 0, false, true));
                StructureHints.tryHintForStructure(player, level, TFStructures.DARK_TOWER);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.FINAL_PLATEAU, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 5 == 0) {
                player.m_6469_(level.m_269111_().m_269425_(), 1.5f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.ACID_RAIN_BURNS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                StructureHints.tryHintForStructure(player, level, TFStructures.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.FIRE_SWAMP, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                player.m_20254_(8);
            }
            StructureHints.tryHintForStructure(player, level, TFStructures.HYDRA_LAIR);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.GLACIER, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, 3, false, true));
            }
            StructureHints.tryHintForStructure(player, level, TFStructures.AURORA_PALACE);
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.HIGHLANDS, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 5 == 0) {
                player.m_6469_(level.m_269111_().m_269425_(), 0.5f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.ACID_RAIN_BURNS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                StructureHints.tryHintForStructure(player, level, TFStructures.TROLL_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.SNOWY_FOREST, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                player.m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), 100, 2, false, true));
                StructureHints.tryHintForStructure(player, level, TFStructures.YETI_CAVE);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.SWAMP, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 60 == 0) {
                MobEffectInstance currentHunger = player.m_21124_(MobEffects.f_19612_);
                int hungerLevel = currentHunger != null ? currentHunger.m_19564_() + 1 : 1;
                player.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 100, hungerLevel, false, true));
                StructureHints.tryHintForStructure(player, level, TFStructures.LABYRINTH);
            }
        });
        TFGenerationSettings.registerBiomeProgressionEnforcement(TFBiomes.THORNLANDS, (player, level) -> {
            if (!level.m_5776_() && player.f_19797_ % 5 == 0) {
                player.m_6469_(level.m_269111_().m_269425_(), 1.0f);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)TFSounds.ACID_RAIN_BURNS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                StructureHints.tryHintForStructure(player, level, TFStructures.TROLL_CAVE);
            }
        });
        DIMENSION = TwilightForestMod.prefix("twilight_forest");
        WORLDGEN_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DIMENSION);
        DIMENSION_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DIMENSION);
    }
}

