/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class TowerBeardComponent
extends TFStructureComponentOld {
    final int size;
    int height;

    public TowerBeardComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this((StructurePieceType)TFStructurePieceTypes.TFLTBea.get(), nbt);
    }

    public TowerBeardComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.size = nbt.m_128451_("beardSize");
        this.height = nbt.m_128451_("beardHeight");
    }

    public TowerBeardComponent(StructurePieceType piece, int i, TowerWingComponent wing, int x, int y, int z) {
        super(piece, i, x, y, z);
        this.m_73519_(wing.m_73549_());
        this.size = wing.size - 2;
        this.height = this.size / 2;
        this.f_73383_ = new BoundingBox(wing.m_73547_().m_162395_() + 1, wing.m_73547_().m_162396_() - this.height - 1, wing.m_73547_().m_162398_() + 1, wing.m_73547_().m_162399_() - 1, wing.m_73547_().m_162396_() - 1, wing.m_73547_().m_162401_() - 1);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("beardSize", this.size);
        tagCompound.m_128405_("beardHeight", this.height);
    }

    public void m_213694_(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.makePyramidBeard(world, rand, sbb);
    }

    private void makePyramidBeard(WorldGenLevel world, RandomSource rand, BoundingBox sbb) {
        for (int y = 0; y <= this.height; ++y) {
            int min = y;
            int max = this.size - y - 1;
            this.m_226776_(world, sbb, min, this.height - y, min, max, this.height - y, max, false, rand, TFStructureComponentOld.getStrongholdStones());
        }
    }
}

