/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import twilightforest.block.BanisterBlock;
import twilightforest.util.FeaturePlacers;

public class WoodPalette {
    public static final Codec<WoodPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("planks").forGetter(p -> p.planks), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("stairs").forGetter(p -> p.stairs), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("slab").forGetter(p -> p.slab), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("button").forGetter(p -> p.button), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("fence").forGetter(p -> p.fence), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("gate").forGetter(p -> p.gate), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("plate").forGetter(p -> p.plate), (App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("banister").forGetter(p -> p.banister)).apply((Applicative)instance, WoodPalette::new));
    private final Set<Block> blocks;
    private final Block planks;
    private final Block stairs;
    private final Block slab;
    private final Block button;
    private final Block fence;
    private final Block gate;
    private final Block plate;
    private final Block banister;

    public WoodPalette(Supplier<Block> planks, Supplier<StairBlock> stairs, Supplier<Block> slab, Supplier<Block> button, Supplier<Block> fence, Supplier<Block> gate, Supplier<Block> plate, Supplier<BanisterBlock> banister) {
        this(planks.get(), (Block)stairs.get(), slab.get(), button.get(), fence.get(), gate.get(), plate.get(), (Block)banister.get());
    }

    public WoodPalette(Block planks, Block stairs, Block slab, Block button, Block fence, Block gate, Block plate, Block banister) {
        this.planks = planks;
        this.stairs = stairs;
        this.slab = slab;
        this.button = button;
        this.fence = fence;
        this.gate = gate;
        this.plate = plate;
        this.banister = banister;
        this.blocks = new HashSet<Block>(List.of(this.planks, this.stairs, this.slab, this.button, this.fence, this.gate, this.plate, this.banister));
    }

    public boolean contains(Block block) {
        return this.blocks.contains(block);
    }

    public StructureTemplate.StructureBlockInfo modifyBlockWithType(WoodPalette targetPalette, StructureTemplate.StructureBlockInfo stateIn) {
        BlockState state = stateIn.f_74676_;
        if (targetPalette.contains(state.m_60734_())) {
            return new StructureTemplate.StructureBlockInfo(stateIn.f_74675_, this.modifyBlockWithType(targetPalette, state), stateIn.f_74677_);
        }
        return stateIn;
    }

    public BlockState modifyBlockWithType(WoodPalette targetPalette, BlockState stateIn) {
        return switch (targetPalette.getWoodShapeFromBlock(stateIn.m_60734_())) {
            case WoodShapes.BLOCK -> this.planks.m_49966_();
            case WoodShapes.STAIRS -> FeaturePlacers.transferAllStateKeys(stateIn, this.stairs);
            case WoodShapes.SLAB -> FeaturePlacers.transferAllStateKeys(stateIn, this.slab);
            case WoodShapes.FENCE -> FeaturePlacers.transferAllStateKeys(stateIn, this.fence);
            case WoodShapes.GATE -> FeaturePlacers.transferAllStateKeys(stateIn, this.gate);
            case WoodShapes.BUTTON -> FeaturePlacers.transferAllStateKeys(stateIn, this.button);
            case WoodShapes.PLATE -> FeaturePlacers.transferAllStateKeys(stateIn, this.plate);
            case WoodShapes.BANISTER -> FeaturePlacers.transferAllStateKeys(stateIn, this.banister);
            default -> stateIn;
        };
    }

    public WoodShapes getWoodShapeFromBlock(Block b) {
        if (b == this.planks) {
            return WoodShapes.BLOCK;
        }
        if (b == this.stairs) {
            return WoodShapes.STAIRS;
        }
        if (b == this.slab) {
            return WoodShapes.SLAB;
        }
        if (b == this.button) {
            return WoodShapes.BUTTON;
        }
        if (b == this.fence) {
            return WoodShapes.FENCE;
        }
        if (b == this.gate) {
            return WoodShapes.GATE;
        }
        if (b == this.plate) {
            return WoodShapes.PLATE;
        }
        if (b == this.banister) {
            return WoodShapes.BANISTER;
        }
        return WoodShapes.INVALID;
    }

    public static enum WoodShapes {
        BLOCK,
        STAIRS,
        SLAB,
        BUTTON,
        FENCE,
        GATE,
        PLATE,
        BANISTER,
        INVALID;

    }
}

