/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;
import twilightforest.data.tags.StructureTagGenerator;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.structures.start.TFStructureStart;

public final class LandmarkUtil {
    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, int chunkX, int chunkZ) {
        return LandmarkUtil.locateNearestMatchingLandmark(level, StructureTagGenerator.LANDMARK, chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, TagKey<Structure> matching, int chunkX, int chunkZ) {
        Optional structureRegistry = level.m_9598_().m_6632_(Registries.f_256944_);
        if (structureRegistry.isEmpty()) {
            return Optional.empty();
        }
        Optional holders = ((Registry)structureRegistry.get()).m_203431_(matching);
        if (holders.isEmpty()) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestMatchingLandmark(level, (HolderSet<Structure>)((HolderSet)holders.get()), chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, HolderSet<Structure> matching, int chunkX, int chunkZ) {
        Set structures = matching.m_203614_().map(Holder::get).collect(Collectors.toSet());
        return LandmarkUtil.locateNearestMatchingLandmark(level, structures::contains, chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestMatchingLandmark(LevelAccessor level, Predicate<Structure> filter, int chunkX, int chunkZ) {
        int centerZ;
        BlockPos nearestFeature = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        int centerX = SectionPos.m_123171_((int)nearestFeature.m_123341_());
        if (!level.m_7232_(centerX, centerZ = SectionPos.m_123171_((int)nearestFeature.m_123343_()))) {
            return Optional.empty();
        }
        ChunkAccess chunkAccess = level.m_46819_(centerX, centerZ, ChunkStatus.f_62315_);
        for (Map.Entry structureEntry : chunkAccess.m_6633_().entrySet()) {
            if (!filter.test((Structure)structureEntry.getKey())) continue;
            return Optional.of((StructureStart)structureEntry.getValue());
        }
        return Optional.empty();
    }

    public static void markStructureConquered(LevelAccessor level, EnforcedHomePoint mobHome, ResourceKey<Structure> structureKey, boolean conquered) {
        LandmarkUtil.markStructureConquered(level, mobHome.getRestrictionCenter(), structureKey, conquered);
    }

    public static void markStructureConquered(LevelAccessor level, BlockPos pos, ResourceKey<Structure> structureKey, boolean conquered) {
        StructureStart structureStart;
        Optional<StructureStart> nearStart = LandmarkUtil.locateNearestLandmarkStart(level, structureKey, pos);
        if (nearStart.isEmpty() || !((structureStart = nearStart.get()) instanceof TFStructureStart)) {
            return;
        }
        TFStructureStart twilightStart = (TFStructureStart)structureStart;
        twilightStart.setConquered(conquered, level);
    }

    @Nullable
    public static Structure structureForKey(LevelReader level, ResourceKey<Structure> structureKey) {
        Optional registry = level.m_9598_().m_6632_(Registries.f_256944_);
        return registry.isPresent() ? (Structure)((Registry)registry.get()).m_6246_(structureKey) : null;
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, ResourceKey<Structure> structureKey, BlockPos pos) {
        return LandmarkUtil.locateNearestLandmarkStart(level, structureKey, SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, ResourceKey<Structure> structureKey, int chunkX, int chunkZ) {
        Structure structure = LandmarkUtil.structureForKey((LevelReader)level, structureKey);
        if (structure == null) {
            return Optional.empty();
        }
        return LandmarkUtil.locateNearestLandmarkStart(level, structure, chunkX, chunkZ);
    }

    public static Optional<StructureStart> locateNearestLandmarkStart(LevelAccessor level, Structure structure, int chunkX, int chunkZ) {
        BlockPos nearestLandmark = LegacyLandmarkPlacements.getNearestCenterXZ(chunkX, chunkZ);
        ChunkAccess chunkAccess = level.m_46819_(SectionPos.m_123171_((int)nearestLandmark.m_123341_()), SectionPos.m_123171_((int)nearestLandmark.m_123343_()), ChunkStatus.f_62315_);
        for (Long packedChunkPos : chunkAccess.m_213649_(structure)) {
            StructureStart structureStart;
            int packedZ;
            int packedX = ChunkPos.m_45592_((long)packedChunkPos);
            if (!level.m_7232_(packedX, packedZ = ChunkPos.m_45602_((long)packedChunkPos)) || (structureStart = level.m_46819_(packedX, packedZ, ChunkStatus.f_62315_).m_213652_(structure)) == null || !structureStart.m_73603_()) continue;
            return Optional.of(structureStart);
        }
        return Optional.empty();
    }

    public static boolean isProgressionEnforced(Level world) {
        return world.m_46469_().m_46207_(TwilightForestMod.ENFORCED_PROGRESSION_RULE);
    }

    private LandmarkUtil() {
    }
}

