/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.TFMazeMapData;
import twilightforest.init.TFItems;

public class MazeMapItem
extends MapItem {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    public MazeMapItem(boolean mapOres, Item.Properties properties) {
        super(properties);
        this.mapOres = mapOres;
    }

    public static ItemStack setupNewMap(Level level, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, int worldY, boolean mapOres) {
        ItemStack itemstack = new ItemStack(mapOres ? (ItemLike)TFItems.FILLED_ORE_MAP.get() : (ItemLike)TFItems.FILLED_MAZE_MAP.get());
        MazeMapItem.createMapData(itemstack, level, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (ResourceKey<Level>)level.m_46472_(), worldY);
        return itemstack;
    }

    @Nullable
    public static TFMazeMapData getData(ItemStack stack, Level level) {
        Integer id = MazeMapItem.m_151131_((ItemStack)stack);
        return id == null ? null : TFMazeMapData.getMazeMapData(level, MazeMapItem.getMapName(id));
    }

    @Nullable
    protected TFMazeMapData getCustomMapData(ItemStack stack, Level level) {
        TFMazeMapData mapdata = MazeMapItem.getData(stack, level);
        if (mapdata == null && !level.m_5776_()) {
            mapdata = MazeMapItem.createMapData(stack, level, level.m_6106_().m_6789_(), level.m_6106_().m_6526_(), 0, false, false, (ResourceKey<Level>)level.m_46472_(), level.m_6106_().m_6527_());
        }
        return mapdata;
    }

    private static TFMazeMapData createMapData(ItemStack stack, Level level, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, ResourceKey<Level> dimension, int y) {
        int i = level.m_7354_();
        int mapSize = 128 * (1 << scale);
        int roundX = Mth.m_14107_((double)(((double)x + 64.0) / (double)mapSize));
        int roundZ = Mth.m_14107_((double)(((double)z + 64.0) / (double)mapSize));
        int scaledX = roundX * mapSize + mapSize / 2 - 64;
        int scaledZ = roundZ * mapSize + mapSize / 2 - 64;
        TFMazeMapData mapdata = new TFMazeMapData(scaledX, scaledZ, (byte)scale, trackingPosition, unlimitedTracking, false, dimension);
        mapdata.calculateMapCenter(level, x, y, z);
        TFMazeMapData.registerMazeMapData(level, mapdata, MazeMapItem.getMapName(i));
        stack.m_41784_().m_128405_("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "mazemap_" + id;
    }

    public void m_42893_(Level level, Entity viewer, MapItemSavedData data) {
        if (level.m_46472_() == data.f_77887_ && viewer instanceof Player) {
            int blocksPerPixel = 1 << data.f_77890_;
            int centerX = data.f_256718_;
            int centerZ = data.f_256789_;
            int viewerX = Mth.m_14107_((double)(viewer.m_20185_() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = Mth.m_14107_((double)(viewer.m_20189_() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (level.m_6042_().f_63856_()) {
                viewRadiusPixels /= 2;
            }
            MapItemSavedData.HoldingPlayer mapdata$mapinfo = data.m_77916_((Player)viewer);
            ++mapdata$mapinfo.f_77960_;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.f_77960_ & 0xF) && !flag) continue;
                flag = false;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    LevelChunk chunk = level.m_46745_(new BlockPos(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.m_6430_()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    if (level.m_6042_().f_63856_()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.f_50493_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 10);
                        } else {
                            multiset.add((Object)Blocks.f_50069_.m_49966_().m_60780_((BlockGetter)level, BlockPos.f_121853_), 100);
                        }
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(worldXRounded, yCenter, worldZRounded);
                        BlockState state = chunk.m_8055_((BlockPos)blockpos$mutableblockpos);
                        multiset.add((Object)state.m_60780_((BlockGetter)level, (BlockPos)blockpos$mutableblockpos));
                        if (state.m_60713_(Blocks.f_50069_) || state.m_60795_()) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.m_142448_(yCenter + i);
                                BlockState searchID = chunk.m_8055_((BlockPos)blockpos$mutableblockpos);
                                if (!searchID.m_60713_(Blocks.f_50069_) || searchID.m_60795_()) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            if (state.m_204336_(BlockTags.f_144262_)) {
                                multiset.add((Object)MaterialColor.f_76365_, 1000);
                            } else if (state.m_204336_(BlockTags.f_13043_)) {
                                multiset.add((Object)MaterialColor.f_76366_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144258_)) {
                                multiset.add((Object)MaterialColor.f_76404_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144261_)) {
                                multiset.add((Object)MaterialColor.f_76368_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144260_)) {
                                multiset.add((Object)MaterialColor.f_76364_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144259_)) {
                                multiset.add((Object)MaterialColor.f_76367_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144263_)) {
                                multiset.add((Object)MaterialColor.f_76369_, 1000);
                            } else if (state.m_204336_(BlockTags.f_144264_)) {
                                multiset.add((Object)MaterialColor.f_76413_, 1000);
                            } else if (state.m_60734_() != Blocks.f_50016_ && state.m_204336_(Tags.Blocks.ORES)) {
                                multiset.add((Object)MaterialColor.f_76418_, 1000);
                            }
                        }
                    }
                    MaterialColor mapcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.f_76398_);
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.f_77891_[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.f_76397_ * 4 + brightness))) continue;
                    data.m_164803_(xPixel, zPixel, b1);
                    data.m_77762_();
                    flag = true;
                }
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        TFMazeMapData mapdata;
        if (!level.m_5776_() && (mapdata = this.getCustomMapData(stack, level)) != null) {
            Player player;
            if (entity instanceof Player) {
                MapDecoration decoration;
                Player entityplayer = (Player)entity;
                mapdata.m_77918_(entityplayer, stack);
                int yProximity = Mth.m_14107_((double)(entityplayer.m_20186_() - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (MapDecoration)mapdata.f_77894_.get(entityplayer.m_7755_().getString())) != null) {
                    mapdata.f_77894_.put(entityplayer.m_7755_().getString(), new MapDecoration(MapDecoration.Type.PLAYER_OFF_MAP, decoration.m_77804_(), decoration.m_77805_(), decoration.m_77806_(), null));
                }
            }
            if (!mapdata.f_77892_ && (isSelected || entity instanceof Player && (player = (Player)entity).m_21206_() == stack)) {
                this.m_42893_(level, entity, mapdata);
            }
        }
    }

    public void m_7836_(ItemStack stack, Level level, Player player) {
    }

    @Nullable
    public Packet<?> m_7233_(ItemStack stack, Level level, Player player) {
        Integer id = MazeMapItem.m_151131_((ItemStack)stack);
        TFMazeMapData mapdata = this.getCustomMapData(stack, level);
        return id == null || mapdata == null ? null : mapdata.m_164796_(id, player);
    }
}

