/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.HollowLogClimbable;
import twilightforest.block.HollowLogHorizontal;
import twilightforest.block.HollowLogVertical;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.client.ISTER;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.item.FurnaceFuelItem;
import twilightforest.item.HollowLogItem;
import twilightforest.item.HugeLilyPadItem;
import twilightforest.item.HugeWaterLilyItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TrophyItem;
import twilightforest.item.WearableItem;

public class TFBlockItems {
    public static void registerBlockItems(RegisterEvent event) {
        if (Objects.equals(event.getForgeRegistry(), ForgeRegistries.ITEMS)) {
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.NAGA_TROPHY, TFBlocks.NAGA_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.LICH_TROPHY, TFBlocks.LICH_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.MINOSHROOM_TROPHY, TFBlocks.MINOSHROOM_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.HYDRA_TROPHY, TFBlocks.HYDRA_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.KNIGHT_PHANTOM_TROPHY, TFBlocks.KNIGHT_PHANTOM_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.UR_GHAST_TROPHY, TFBlocks.UR_GHAST_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.ALPHA_YETI_TROPHY, TFBlocks.ALPHA_YETI_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.SNOW_QUEEN_TROPHY, TFBlocks.SNOW_QUEEN_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.trophyBlock(TFBlocks.QUEST_RAM_TROPHY, TFBlocks.QUEST_RAM_WALL_TROPHY));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGA_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.LICH_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINOSHROOM_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HYDRA_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UR_GHAST_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ALPHA_YETI_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SNOW_QUEEN_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FINAL_BOSS_BOSS_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ETCHED_NAGASTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_ETCHED_NAGASTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_ETCHED_NAGASTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGASTONE_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGASTONE_STAIRS_LEFT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGASTONE_STAIRS_RIGHT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGASTONE_HEAD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.NAGASTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SPIRAL_BRICKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWISTED_STONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWISTED_STONE_PILLAR));
            TFBlockItems.register(event, new BlockItem((Block)TFBlocks.KEEPSAKE_CASKET.get(), new Item.Properties().m_41486_()){

                public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                    consumer.accept(new IClientItemExtensions(){

                        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                            return new ISTER();
                        }
                    });
                }
            });
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANDELABRA));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BOLD_STONE_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DEATH_TOME_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.EMPTY_CANOPY_BOOKSHELF));
            TFBlockItems.register(event, TFBlockItems.skullCandleItem(TFBlocks.ZOMBIE_SKULL_CANDLE, TFBlocks.ZOMBIE_WALL_SKULL_CANDLE));
            TFBlockItems.register(event, TFBlockItems.skullCandleItem(TFBlocks.SKELETON_SKULL_CANDLE, TFBlocks.SKELETON_WALL_SKULL_CANDLE));
            TFBlockItems.register(event, TFBlockItems.skullCandleItem(TFBlocks.WITHER_SKELE_SKULL_CANDLE, TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE));
            TFBlockItems.register(event, TFBlockItems.skullCandleItem(TFBlocks.CREEPER_SKULL_CANDLE, TFBlocks.CREEPER_WALL_SKULL_CANDLE));
            TFBlockItems.register(event, TFBlockItems.skullCandleItem(TFBlocks.PLAYER_SKULL_CANDLE, TFBlocks.PLAYER_WALL_SKULL_CANDLE));
            TFBlockItems.register(event, (BlockItem)new HugeWaterLilyItem((Block)TFBlocks.HUGE_WATER_LILY.get(), new Item.Properties()));
            TFBlockItems.register(event, (BlockItem)new HugeLilyPadItem((HugeLilyPadBlock)((Object)TFBlocks.HUGE_LILY_PAD.get()), new Item.Properties()));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MAZESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MAZESTONE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_MAZESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_MAZESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DECORATIVE_MAZESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CUT_MAZESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MAZESTONE_BORDER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MAZESTONE_MOSAIC));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SMOKER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_SMOKER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FIRE_JET));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_FIRE_JET));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRONGHOLD_SHIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TROPHY_PEDESTAL));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UNDERBRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_UNDERBRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_UNDERBRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UNDERBRICK_FLOOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TOWERWOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_TOWERWOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_TOWERWOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.INFESTED_TOWERWOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_TOWERWOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.VANISHING_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.REAPPEARING_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.LOCKED_VANISHING_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CARMINITE_BUILDER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ANTIBUILDER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CARMINITE_REACTOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GHAST_TRAP));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.AURORA_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.AURORA_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.AURORA_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.AURORALIZED_GLASS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TROLLSTEINN));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TROLLVIDR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UNRIPE_TROLLBER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TROLLBER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HUGE_MUSHGLOOM));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HUGE_MUSHGLOOM_STEM));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UBEROUS_SOIL));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HUGE_STALK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BEANSTALK_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.WISPY_CLOUD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FLUFFY_CLOUD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GIANT_COBBLESTONE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GIANT_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GIANT_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GIANT_OBSIDIAN));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DEADROCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_DEADROCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.WEATHERED_DEADROCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BROWN_THORNS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GREEN_THORNS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BURNT_THORNS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.THORN_ROSE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.THORN_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CASTLE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.WORN_CASTLE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_CASTLE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_CASTLE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.THICK_CASTLE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CASTLE_ROOF_TILE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_TILE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_PILLAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_TILE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.WORN_CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CRACKED_CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSSY_CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.PINK_CASTLE_RUNE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.YELLOW_CASTLE_RUNE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BLUE_CASTLE_RUNE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.VIOLET_CASTLE_RUNE_BRICK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.PINK_CASTLE_DOOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.YELLOW_CASTLE_DOOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BLUE_CASTLE_DOOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.VIOLET_CASTLE_DOOR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.PINK_FORCE_FIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ORANGE_FORCE_FIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.GREEN_FORCE_FIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.BLUE_FORCE_FIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.VIOLET_FORCE_FIELD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.UNCRAFTING_TABLE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CINDER_FURNACE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CINDER_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CINDER_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SLIDER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.IRON_LADDER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.IRONWOOD_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STEELEAF_BLOCK));
            TFBlockItems.register(event, TFBlockItems.fireImmuneBlock(TFBlocks.FIERY_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.KNIGHTMETAL_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CARMINITE_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ARCTIC_FUR_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MOSS_PATCH));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MAYAPPLE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CLOVER_PATCH));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FIDDLEHEAD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MUSHGLOOM));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TORCHBERRY_PLANT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ROOT_STRAND));
            TFBlockItems.register(event, TFBlockItems.placeOnWaterBlockItemReplaceable(TFBlocks.FALLEN_LEAVES));
            TFBlockItems.register(event, TFBlockItems.wearableBlock(TFBlocks.FIREFLY, TFBlockEntities.FIREFLY));
            TFBlockItems.register(event, TFBlockItems.wearableBlock(TFBlocks.CICADA, TFBlockEntities.CICADA));
            TFBlockItems.register(event, TFBlockItems.wearableBlock(TFBlocks.MOONWORM, TFBlockEntities.MOONWORM));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FIREFLY_JAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.FIREFLY_SPAWNER));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CICADA_JAR));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HEDGE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.ROOT_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.LIVEROOT_BLOCK));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_ROOT));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.RAINBOW_OAK_LEAVES));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TWILIGHT_OAK_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_CANOPY_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_MANGROVE_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_DARK_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TIME_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TRANSFORMATION_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_MINING_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_SORTING_LOG));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_CANOPY_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_MANGROVE_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_DARK_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TIME_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_TRANSFORMATION_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_MINING_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.STRIPPED_SORTING_WOOD));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_LOG_CORE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LOG_CORE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_LOG_CORE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_LOG_CORE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARKWOOD_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.HOLLOW_OAK_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_SAPLING));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.RAINBOW_OAK_SAPLING));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.OAK_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.SPRUCE_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.BIRCH_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.JUNGLE_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.ACACIA_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.DARK_OAK_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.CRIMSON_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.WARPED_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.VANGROVE_BANISTER, 300));
            TFBlockItems.registerWithCustomName(event, "hollow_oak_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_OAK_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_spruce_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_SPRUCE_LOG_HORIZONTAL, TFBlocks.HOLLOW_SPRUCE_LOG_VERTICAL, TFBlocks.HOLLOW_SPRUCE_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_birch_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_BIRCH_LOG_HORIZONTAL, TFBlocks.HOLLOW_BIRCH_LOG_VERTICAL, TFBlocks.HOLLOW_BIRCH_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_jungle_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_JUNGLE_LOG_HORIZONTAL, TFBlocks.HOLLOW_JUNGLE_LOG_VERTICAL, TFBlocks.HOLLOW_JUNGLE_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_acacia_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_ACACIA_LOG_HORIZONTAL, TFBlocks.HOLLOW_ACACIA_LOG_VERTICAL, TFBlocks.HOLLOW_ACACIA_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_dark_oak_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_DARK_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_DARK_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_DARK_OAK_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_crimson_stem", TFBlockItems.hollowLog(TFBlocks.HOLLOW_CRIMSON_STEM_HORIZONTAL, TFBlocks.HOLLOW_CRIMSON_STEM_VERTICAL, TFBlocks.HOLLOW_CRIMSON_STEM_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_warped_stem", TFBlockItems.hollowLog(TFBlocks.HOLLOW_WARPED_STEM_HORIZONTAL, TFBlocks.HOLLOW_WARPED_STEM_VERTICAL, TFBlocks.HOLLOW_WARPED_STEM_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_vangrove_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_VANGROVE_LOG_HORIZONTAL, TFBlocks.HOLLOW_VANGROVE_LOG_VERTICAL, TFBlocks.HOLLOW_VANGROVE_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_twilight_oak_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_canopy_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_CANOPY_LOG_HORIZONTAL, TFBlocks.HOLLOW_CANOPY_LOG_VERTICAL, TFBlocks.HOLLOW_CANOPY_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_mangrove_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_MANGROVE_LOG_HORIZONTAL, TFBlocks.HOLLOW_MANGROVE_LOG_VERTICAL, TFBlocks.HOLLOW_MANGROVE_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_dark_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_DARK_LOG_HORIZONTAL, TFBlocks.HOLLOW_DARK_LOG_VERTICAL, TFBlocks.HOLLOW_DARK_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_time_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_TIME_LOG_HORIZONTAL, TFBlocks.HOLLOW_TIME_LOG_VERTICAL, TFBlocks.HOLLOW_TIME_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_transformation_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_TRANSFORMATION_LOG_HORIZONTAL, TFBlocks.HOLLOW_TRANSFORMATION_LOG_VERTICAL, TFBlocks.HOLLOW_TRANSFORMATION_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_mining_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_MINING_LOG_HORIZONTAL, TFBlocks.HOLLOW_MINING_LOG_VERTICAL, TFBlocks.HOLLOW_MINING_LOG_CLIMBABLE));
            TFBlockItems.registerWithCustomName(event, "hollow_sorting_log", TFBlockItems.hollowLog(TFBlocks.HOLLOW_SORTING_LOG_HORIZONTAL, TFBlocks.HOLLOW_SORTING_LOG_VERTICAL, TFBlocks.HOLLOW_SORTING_LOG_CLIMBABLE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.TWILIGHT_OAK_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.TWILIGHT_OAK_SIGN, TFBlocks.TWILIGHT_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.CANOPY_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.CANOPY_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.CANOPY_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.CANOPY_SIGN, TFBlocks.CANOPY_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.CANOPY_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.CANOPY_BOOKSHELF));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MANGROVE_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MANGROVE_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MANGROVE_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.MANGROVE_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.MANGROVE_SIGN, TFBlocks.MANGROVE_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MANGROVE_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.DARK_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.DARK_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.DARK_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.DARK_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.DARKWOOD_SIGN, TFBlocks.DARKWOOD_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.DARKWOOD_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TIME_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TIME_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TIME_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.TIME_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.TIME_SIGN, TFBlocks.TIME_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TIME_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.TRANSFORMATION_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.TRANSFORMATION_SIGN, TFBlocks.TRANSFORMATION_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MINING_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MINING_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.MINING_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.MINING_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.MINING_SIGN, TFBlocks.MINING_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.MINING_BANISTER, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_PLANKS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_STAIRS));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_SLAB));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_BUTTON));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.SORTING_FENCE, 300));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.SORTING_GATE, 300));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_PLATE));
            TFBlockItems.register(event, TFBlockItems.blockItem(TFBlocks.SORTING_TRAPDOOR));
            TFBlockItems.register(event, TFBlockItems.tallBlock(TFBlocks.SORTING_DOOR));
            TFBlockItems.register(event, TFBlockItems.signBlock(TFBlocks.SORTING_SIGN, TFBlocks.SORTING_WALL_SIGN));
            TFBlockItems.register(event, TFBlockItems.burningItem(TFBlocks.SORTING_BANISTER, 300));
            TFBlockItems.makeBEWLRItem(event, TFBlocks.TWILIGHT_OAK_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.CANOPY_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.MANGROVE_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.DARKWOOD_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.TIME_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.TRANSFORMATION_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.MINING_CHEST);
            TFBlockItems.makeBEWLRItem(event, TFBlocks.SORTING_CHEST);
        }
    }

    private static BlockItem hollowLog(RegistryObject<HollowLogHorizontal> horizontalLog, RegistryObject<HollowLogVertical> verticalLog, RegistryObject<HollowLogClimbable> climbable) {
        return new HollowLogItem(horizontalLog, verticalLog, climbable, new Item.Properties());
    }

    private static <B extends Block> BlockItem blockItem(RegistryObject<B> block) {
        return new BlockItem((Block)block.get(), new Item.Properties());
    }

    private static <B extends Block> BlockItem placeOnWaterBlockItemReplaceable(final RegistryObject<B> block) {
        return new BlockItem((Block)block.get(), new Item.Properties()){

            public InteractionResult m_6225_(UseOnContext context) {
                return context.m_43725_().m_8055_(context.m_8083_()).m_60713_((Block)block.get()) ? super.m_6225_(context) : InteractionResult.PASS;
            }

            public InteractionResultHolder<ItemStack> m_7203_(Level p_220231_, Player p_220232_, InteractionHand p_220233_) {
                BlockHitResult blockhitresult = 2.m_41435_((Level)p_220231_, (Player)p_220232_, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
                BlockHitResult blockhitresult1 = blockhitresult.m_82430_(blockhitresult.m_82425_().m_7494_());
                InteractionResult interactionresult = super.m_6225_(new UseOnContext(p_220232_, p_220233_, blockhitresult1));
                return new InteractionResultHolder(interactionresult, (Object)p_220232_.m_21120_(p_220233_));
            }
        };
    }

    private static <B extends Block> BlockItem fireImmuneBlock(RegistryObject<B> block) {
        return new BlockItem((Block)block.get(), new Item.Properties().m_41486_());
    }

    private static <B extends AbstractSkullCandleBlock> BlockItem skullCandleItem(RegistryObject<B> floor, RegistryObject<B> wall) {
        return new SkullCandleItem((AbstractSkullCandleBlock)((Object)floor.get()), (AbstractSkullCandleBlock)((Object)wall.get()), new Item.Properties().m_41497_(Rarity.UNCOMMON)){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return new ISTER();
                    }
                });
            }
        };
    }

    private static <B extends Block> BlockItem burningItem(RegistryObject<B> block, int burntime) {
        return new FurnaceFuelItem((Block)block.get(), new Item.Properties(), burntime);
    }

    private static <B extends Block, W extends Block> BlockItem trophyBlock(RegistryObject<B> block, RegistryObject<W> wallblock) {
        return new TrophyItem((Block)block.get(), (Block)wallblock.get(), new Item.Properties().m_41497_(TwilightForestMod.getRarity())){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return new ISTER();
                    }
                });
            }
        };
    }

    private static <T extends Block, E extends BlockEntity> BlockItem wearableBlock(RegistryObject<T> block, RegistryObject<BlockEntityType<E>> tileentity) {
        return new WearableItem((Block)block.get(), new Item.Properties()){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return new ISTER();
                    }
                });
            }
        };
    }

    private static <B extends Block> BlockItem tallBlock(RegistryObject<B> block) {
        return new DoubleHighBlockItem((Block)block.get(), new Item.Properties());
    }

    private static <B extends Block, W extends Block> BlockItem signBlock(RegistryObject<B> block, RegistryObject<W> wallblock) {
        return new SignItem(new Item.Properties().m_41487_(16), (Block)block.get(), (Block)wallblock.get());
    }

    private static void makeBEWLRItem(RegisterEvent event, RegistryObject<? extends Block> block) {
        TFBlockItems.register(event, new BlockItem((Block)block.get(), new Item.Properties()){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return new ISTER();
                    }
                });
            }
        });
    }

    private static void register(RegisterEvent event, BlockItem item) {
        event.register(ForgeRegistries.Keys.ITEMS, (T helper) -> helper.register(ForgeRegistries.BLOCKS.getKey((Object)item.m_40614_()), (Object)item));
    }

    private static void registerWithCustomName(RegisterEvent event, String name, BlockItem item) {
        event.register(ForgeRegistries.Keys.ITEMS, (T helper) -> helper.register(name, (Object)item));
    }
}

