/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.TFArrow;
import twilightforest.init.TFEntities;

public class SeekerArrow
extends TFArrow {
    private static final EntityDataAccessor<Integer> TARGET = SynchedEntityData.m_135353_(SeekerArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final double seekDistance = 5.0;
    private static final double seekFactor = 0.8;
    private static final double seekAngle = 0.5235987755982988;
    private static final double seekThreshold = 0.5;

    public SeekerArrow(EntityType<? extends SeekerArrow> type, Level world) {
        super(type, world);
        this.m_36781_(1.0);
    }

    public SeekerArrow(Level world, Entity shooter) {
        super((EntityType<? extends TFArrow>)((EntityType)TFEntities.SEEKER_ARROW.get()), world, shooter);
        this.m_36781_(1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET, (Object)-1);
    }

    public void m_8119_() {
        if (this.isThisArrowFlying()) {
            Entity target;
            if (!this.m_9236_().m_5776_()) {
                this.updateTarget();
            }
            if (this.m_9236_().m_5776_() && !this.f_36703_) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123771_, this.m_20185_() + this.m_20184_().m_7096_() * (double)i / 4.0, this.m_20186_() + this.m_20184_().m_7098_() * (double)i / 4.0, this.m_20189_() + this.m_20184_().m_7094_() * (double)i / 4.0, -this.m_20184_().m_7096_(), -this.m_20184_().m_7098_() + 0.2, -this.m_20184_().m_7094_());
                }
            }
            if ((target = this.getTarget()) != null) {
                Vec3 targetVec = this.getVectorToTarget(target).m_82490_(0.8);
                Vec3 courseVec = this.getMotionVec();
                double courseLen = courseVec.m_82553_();
                double targetLen = targetVec.m_82553_();
                double totalLen = Math.sqrt(courseLen * courseLen + targetLen * targetLen);
                double dotProduct = courseVec.m_82526_(targetVec) / (courseLen * targetLen);
                if (dotProduct > 0.5) {
                    Vec3 newMotion = courseVec.m_82490_(courseLen / totalLen).m_82549_(targetVec.m_82490_(courseLen / totalLen));
                    this.m_20256_(newMotion.m_82520_(0.0, (double)0.045f, 0.0));
                } else if (!this.m_9236_().m_5776_()) {
                    this.setTarget(null);
                }
            }
        }
        super.m_8119_();
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target == null) {
            AABB positionBB;
            AABB targetBB = positionBB = new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 courseVec = this.getMotionVec().m_82490_(5.0).m_82524_(0.5235988f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            courseVec = this.getMotionVec().m_82490_(5.0).m_82524_(-0.5235988f);
            targetBB = targetBB.m_82367_(positionBB.m_82383_(courseVec));
            targetBB = targetBB.m_82377_(0.0, 2.5, 0.0);
            double closestDot = -1.0;
            LivingEntity closestTarget = null;
            List entityList = this.m_9236_().m_45976_(LivingEntity.class, targetBB);
            List monsters = entityList.stream().filter(l -> l instanceof Monster).collect(Collectors.toList());
            if (!monsters.isEmpty()) {
                for (LivingEntity monster : monsters) {
                    if (((Monster)monster).m_5448_() != this.m_19749_()) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
                for (LivingEntity monster : monsters) {
                    if (monster instanceof NeutralMob || !monster.m_142582_((Entity)this)) continue;
                    this.setTarget((Entity)monster);
                    return;
                }
            }
            for (LivingEntity living : entityList) {
                Vec3 targetVec;
                Vec3 motionVec;
                double dot;
                TamableAnimal animal;
                if (!living.m_142582_((Entity)this) || living == this.m_19749_() || this.m_19749_() != null && living instanceof TamableAnimal && (animal = (TamableAnimal)living).m_269323_() == this.m_19749_() || !((dot = (motionVec = this.getMotionVec().m_82541_()).m_82526_(targetVec = this.getVectorToTarget((Entity)living).m_82541_())) > Math.max(closestDot, 0.5))) continue;
                closestDot = dot;
                closestTarget = living;
            }
            if (closestTarget != null) {
                this.setTarget((Entity)closestTarget);
            }
        }
    }

    private Vec3 getMotionVec() {
        return new Vec3(this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), this.m_20184_().m_7094_());
    }

    private Vec3 getVectorToTarget(Entity target) {
        return new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() + (double)target.m_20192_() - this.m_20186_(), target.m_20189_() - this.m_20189_());
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity e) {
        this.f_19804_.m_135381_(TARGET, (Object)(e == null ? -1 : e.m_19879_()));
    }

    private boolean isThisArrowFlying() {
        return !this.f_36703_ && this.m_20184_().m_82556_() > 1.0;
    }

    protected void m_5790_(EntityHitResult result) {
        this.m_36762_(false);
        super.m_5790_(result);
    }
}

