/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.entity.projectile.TFThrowable;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.util.EntityUtil;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class NatureBolt
extends TFThrowable
implements ITFProjectile,
ItemSupplier {
    public NatureBolt(EntityType<? extends NatureBolt> type, Level level) {
        super(type, level);
    }

    public NatureBolt(Level level, LivingEntity owner) {
        super((EntityType<? extends TFThrowable>)((EntityType)TFEntities.NATURE_BOLT.get()), level, owner);
    }

    public void m_8119_() {
        super.m_8119_();
        this.makeTrail((ParticleOptions)ParticleTypes.f_123748_, 5);
    }

    protected float m_7139_() {
        return 0.003f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.m_9236_().m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50050_.m_49966_()), false, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, this.f_19796_.m_188500_() * 0.2, this.f_19796_.m_188583_() * 0.05);
            }
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        BlockPos blockPosHit = result.m_82425_();
        Material materialHit = this.m_9236_().m_8055_(blockPosHit).m_60767_();
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            if (materialHit == Material.f_76315_) {
                ItemStack dummy = new ItemStack((ItemLike)Items.f_42499_, 1);
                if (BoneMealItem.m_40627_((ItemStack)dummy, (Level)this.m_9236_(), (BlockPos)blockPosHit)) {
                    this.m_9236_().m_46796_(2005, blockPosHit, 0);
                }
            } else if (materialHit.m_76333_() && this.canReplaceBlock(this.m_9236_(), blockPosHit)) {
                this.m_9236_().m_46597_(blockPosHit, (BlockState)Blocks.f_50052_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity owner = this.m_19749_();
        Entity entityHit = result.m_82443_();
        if (entityHit instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityHit;
            if ((owner == null || entityHit != owner && entityHit != owner.m_20202_()) && entityHit.m_6469_(TFDamageTypes.getIndirectEntityDamageSource(this.m_9236_(), TFDamageTypes.LEAF_BRAIN, this.m_19749_(), (Entity)this, new EntityType[0]), 2.0f) && this.m_9236_().m_46791_() != Difficulty.PEACEFUL) {
                int poisonTime = this.m_9236_().m_46791_() == Difficulty.HARD ? 7 : 3;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonTime * 20, 0));
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    private boolean canReplaceBlock(Level level, BlockPos pos) {
        return !level.m_8055_(pos).m_155947_() && level.m_8055_(pos).m_60804_((BlockGetter)level, pos) && level.m_8055_(pos).m_204336_(BlockTagGenerator.DRUID_PROJECTILE_REPLACEABLE) && EntityUtil.canDestroyBlock(level, pos, (Entity)this);
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)Items.f_42404_);
    }
}

