/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.ThrownBlock;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.util.WorldUtil;

public class Troll
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> ROCK_FLAG = SynchedEntityData.m_135353_(Troll.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier ROCK_MODIFIER = new AttributeModifier("Rock follow boost", 24.0, AttributeModifier.Operation.ADDITION);
    private RangedAttackGoal aiArrowAttack;
    private MeleeAttackGoal aiAttackOnCollide;
    private int rockCooldown = 300;
    @Nullable
    private BlockState rock;

    public Troll(EntityType<? extends Troll> type, Level world) {
        super(type, world);
    }

    public void m_8099_() {
        this.aiArrowAttack = new RangedAttackGoal((RangedAttackMob)this, 1.0, 20, 60, 15.0f);
        this.aiAttackOnCollide = new MeleeAttackGoal((PathfinderMob)this, 1.2, false);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Troll.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        if (!this.m_9236_().m_5776_()) {
            this.setCombatTask();
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 7.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && !this.hasRock() && this.m_5448_() != null) {
            if (this.rockCooldown > 0) {
                --this.rockCooldown;
            } else {
                RandomSource random = this.m_217043_();
                Level level = this.f_19853_;
                int i = Mth.m_14107_((double)(this.m_20185_() - 2.0 + random.m_188500_() * 4.0));
                int j = Mth.m_14107_((double)(this.m_20186_() + random.m_188500_() * 3.0));
                int k = Mth.m_14107_((double)(this.m_20189_() - 2.0 + random.m_188500_() * 4.0));
                BlockPos blockpos = new BlockPos(i, j, k);
                BlockState blockstate = level.m_8055_(blockpos);
                Vec3 vec3 = new Vec3((double)this.m_146903_() + 0.5, (double)j + 0.5, (double)this.m_146907_() + 0.5);
                Vec3 vec31 = new Vec3((double)i + 0.5, (double)j + 0.5, (double)k + 0.5);
                BlockHitResult blockhitresult = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
                boolean flag = blockhitresult.m_82425_().equals((Object)blockpos);
                if (blockstate.m_204336_(BlockTags.f_13061_) && flag) {
                    this.rock = level.m_8055_(blockpos);
                    level.m_7471_(blockpos, false);
                    level.m_142346_((Entity)this, GameEvent.f_157794_, blockpos);
                }
                if (this.rock != null) {
                    this.setHasRock(true);
                    ThrownBlock block = new ThrownBlock(level, (LivingEntity)this, this.rock);
                    block.m_20329_((Entity)this);
                    level.m_7967_((Entity)block);
                }
            }
        }
    }

    public double m_6048_() {
        return super.m_6048_() + 1.75;
    }

    public void m_7332_(Entity entity) {
        super.m_7332_(entity);
        entity.m_146926_(this.m_146909_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROCK_FLAG, (Object)false);
    }

    public boolean hasRock() {
        return (Boolean)this.f_19804_.m_135370_(ROCK_FLAG);
    }

    public void setHasRock(boolean rock) {
        this.f_19804_.m_135381_(ROCK_FLAG, (Object)rock);
        if (!this.m_9236_().m_5776_()) {
            if (rock) {
                if (!Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22109_(ROCK_MODIFIER)) {
                    Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22118_(ROCK_MODIFIER);
                }
            } else {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22130_(ROCK_MODIFIER);
            }
            this.setCombatTask();
        }
    }

    public boolean m_7327_(Entity entity) {
        return super.m_7327_(entity);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasRock", this.hasRock());
        compound.m_128405_("RockCooldown", this.rockCooldown);
        if (this.rock != null) {
            compound.m_128365_("RockState", (Tag)NbtUtils.m_129202_((BlockState)this.rock));
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasRock(compound.m_128471_("HasRock"));
        this.rockCooldown = compound.m_128451_("RockCooldown");
        this.rock = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compound.m_128469_("RockState"));
    }

    private void setCombatTask() {
        this.f_21345_.m_25363_((Goal)this.aiAttackOnCollide);
        this.f_21345_.m_25363_((Goal)this.aiArrowAttack);
        if (this.hasRock()) {
            this.f_21345_.m_25352_(4, (Goal)this.aiArrowAttack);
        } else {
            this.f_21345_.m_25352_(4, (Goal)this.aiAttackOnCollide);
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ % 5 == 0) {
            this.ripenTrollBerNearby(this.f_20919_ / 5);
        }
    }

    private void ripenTrollBerNearby(int offset) {
        int range = 12;
        for (BlockPos pos : WorldUtil.getAllAround(new BlockPos((Vec3i)this.m_20183_()), range)) {
            this.ripenBer(offset, pos);
        }
    }

    private void ripenBer(int offset, BlockPos pos) {
        if (this.m_9236_().m_8055_(pos).m_60734_() == TFBlocks.UNRIPE_TROLLBER.get() && this.m_217043_().m_188499_() && Math.abs(pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 5 == offset) {
            this.m_9236_().m_46597_(pos, ((Block)TFBlocks.TROLLBER.get()).m_49966_());
            this.m_9236_().m_46796_(2004, pos, 0);
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.hasRock()) {
            ThrownBlock blocc = new ThrownBlock(this.m_9236_(), (LivingEntity)this, this.rock);
            double d0 = target.m_20185_() - this.m_20185_();
            double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - blocc.m_20186_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
            blocc.m_6686_(d0, d1 + d3 * 0.2, d2, 1.6f, 4 - this.m_9236_().m_46791_().m_19028_());
            this.m_5496_((SoundEvent)TFSounds.TROLL_THROWS_ROCK.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            this.m_146850_(GameEvent.f_157778_);
            this.m_9236_().m_7967_((Entity)blocc);
            this.setHasRock(false);
            if (!this.m_20197_().isEmpty() && Objects.requireNonNull(this.m_146895_()).m_6095_() == TFEntities.THROWN_BLOCK.get()) {
                this.m_146895_().m_146870_();
            }
            this.rockCooldown = 300;
            this.rock = null;
        }
    }
}

