/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.IBreathAttacker;
import twilightforest.entity.ai.goal.BreathAttackGoal;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class FireBeetle
extends Monster
implements IBreathAttacker {
    private static final EntityDataAccessor<Boolean> BREATHING = SynchedEntityData.m_135353_(FireBeetle.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int BREATH_DURATION = 10;
    private static final int BREATH_DAMAGE = 2;

    public FireBeetle(EntityType<? extends FireBeetle> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new BreathAttackGoal<FireBeetle>(this, 5.0f, 30, 0.1f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREATHING, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.FIRE_BEETLE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.FIRE_BEETLE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
        this.m_5496_((SoundEvent)TFSounds.FIRE_BEETLE_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    public boolean isBreathing() {
        return (Boolean)this.f_19804_.m_135370_(BREATHING);
    }

    @Override
    public void setBreathing(boolean flag) {
        this.f_19804_.m_135381_(BREATHING, (Object)flag);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isBreathing()) {
            Vec3 look = this.m_20154_();
            double dist = 0.9;
            double px = this.m_20185_() + look.m_7096_() * dist;
            double py = this.m_20186_() + 0.25 + look.m_7098_() * dist;
            double pz = this.m_20189_() + look.m_7094_() * dist;
            for (int i = 0; i < 2; ++i) {
                double dx = look.m_7096_();
                double dy = look.m_7098_();
                double dz = look.m_7094_();
                double spread = 5.0 + this.m_217043_().m_188500_() * 2.5;
                double velocity = 0.15 + this.m_217043_().m_188500_() * 0.15;
                dx += this.m_217043_().m_188583_() * 0.0075 * spread;
                dy += this.m_217043_().m_188583_() * 0.0075 * spread;
                dz += this.m_217043_().m_188583_() * 0.0075 * spread;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
            this.m_5496_((SoundEvent)TFSounds.FIRE_BEETLE_SHOOT.get(), this.m_217043_().m_188501_() * 0.5f, this.m_217043_().m_188501_() * 0.5f);
            this.m_146850_(GameEvent.f_157778_);
        }
    }

    public int m_8132_() {
        return 500;
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() * 0.6f;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public void doBreathAttack(Entity target) {
        if (!target.m_5825_() && target.m_6469_(TFDamageTypes.getEntityDamageSource(this.m_9236_(), TFDamageTypes.SCORCHED, (Entity)this, new EntityType[0]), 2.0f)) {
            target.m_20254_(10);
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.isBreathing()) {
            return entity.m_6469_(TFDamageTypes.getEntityDamageSource(this.m_9236_(), TFDamageTypes.SCORCHED, (Entity)this, new EntityType[0]), 2.0f);
        }
        return super.m_7327_(entity);
    }
}

