/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import twilightforest.entity.EnforcedHomePoint;
import twilightforest.entity.ai.goal.GhastguardAttackGoal;
import twilightforest.entity.ai.goal.GhastguardHomedFlightGoal;
import twilightforest.entity.ai.goal.GhastguardRandomFlyGoal;
import twilightforest.entity.boss.UrGhast;
import twilightforest.init.TFSounds;

public class CarminiteGhastguard
extends Ghast
implements EnforcedHomePoint {
    private static final EntityDataAccessor<Byte> ATTACK_STATUS = SynchedEntityData.m_135353_(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ATTACK_TIMER = SynchedEntityData.m_135353_(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ATTACK_PREVTIMER = SynchedEntityData.m_135353_(CarminiteGhastguard.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private GhastguardAttackGoal attackAI;
    protected float wanderFactor = 16.0f;
    private int inTrapCounter = 0;

    public CarminiteGhastguard(EntityType<? extends CarminiteGhastguard> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATUS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TIMER, (Object)0);
        this.f_19804_.m_135372_(ATTACK_PREVTIMER, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new GhastguardHomedFlightGoal(this));
        if (!(this instanceof UrGhast)) {
            this.f_21345_.m_25352_(5, (Goal)new GhastguardRandomFlyGoal(this));
        }
        this.f_21345_.m_25352_(7, (Goal)new Ghast.GhastLookGoal((Ghast)this));
        this.attackAI = new GhastguardAttackGoal(this);
        this.f_21345_.m_25352_(7, (Goal)this.attackAI);
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public float getWanderFactor() {
        return this.wanderFactor;
    }

    public void setInTrap() {
        this.inTrapCounter = 10;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Ghast.m_32752_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TFSounds.GHASTGUARD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TFSounds.GHASTGUARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TFSounds.GHASTGUARD_DEATH.get();
    }

    public SoundEvent getFireSound() {
        return (SoundEvent)TFSounds.GHASTGUARD_SHOOT.get();
    }

    public SoundEvent getWarnSound() {
        return (SoundEvent)TFSounds.GHASTGUARD_WARN.get();
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public int m_8100_() {
        return 160;
    }

    public int m_5792_() {
        return 8;
    }

    public void m_8107_() {
        if (this.m_217043_().m_188499_()) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20185_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.m_217043_().m_188500_() * (double)this.m_20206_() - 0.25, this.m_20189_() + (this.m_217043_().m_188500_() - 0.5) * (double)this.m_20205_(), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        if (this.inTrapCounter > 0) {
            --this.inTrapCounter;
            this.m_6710_(null);
        }
        boolean status = this.m_5448_() != null && this.shouldAttack(this.m_5448_());
        this.f_19804_.m_135381_(ATTACK_STATUS, (Object)((byte)(status ? 1 : 0)));
        this.f_19804_.m_135381_(ATTACK_TIMER, (Object)((byte)this.attackAI.attackTimer));
        this.f_19804_.m_135381_(ATTACK_PREVTIMER, (Object)((byte)this.attackAI.prevAttackTimer));
    }

    public int getAttackStatus() {
        return ((Byte)this.f_19804_.m_135370_(ATTACK_STATUS)).byteValue();
    }

    public int getAttackTimer() {
        return ((Byte)this.f_19804_.m_135370_(ATTACK_TIMER)).byteValue();
    }

    public int getPrevAttackTimer() {
        return ((Byte)this.f_19804_.m_135370_(ATTACK_PREVTIMER)).byteValue();
    }

    public boolean shouldAttack(LivingEntity living) {
        return true;
    }

    public int m_8132_() {
        return 500;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public void spitFireball() {
        Vec3 vec3d = this.m_20252_(1.0f);
        double d2 = this.m_5448_().m_20185_() - (this.m_20185_() + vec3d.m_7096_() * 4.0);
        double d3 = this.m_5448_().m_20191_().f_82289_ + (double)(this.m_5448_().m_20206_() / 2.0f) - (0.5 + this.m_20186_() + (double)(this.m_20206_() / 2.0f));
        double d4 = this.m_5448_().m_20189_() - (this.m_20189_() + vec3d.m_7094_() * 4.0);
        LargeFireball entitylargefireball = new LargeFireball(this.m_9236_(), (LivingEntity)this, d2, d3, d4, this.m_32751_());
        entitylargefireball.m_6034_(this.m_20185_() + vec3d.m_7096_() * 4.0, this.m_20186_() + (double)(this.m_20206_() / 2.0f) + 0.5, this.m_20189_() + vec3d.m_7094_() * 4.0);
        this.m_9236_().m_7967_((Entity)entitylargefireball);
        if (this.m_217043_().m_188503_(6) == 0) {
            this.m_6710_(null);
        }
    }

    public static boolean ghastSpawnHandler(EntityType<? extends CarminiteGhastguard> entityType, LevelAccessor accessor, MobSpawnType type, BlockPos pos, RandomSource random) {
        return accessor.m_46791_() != Difficulty.PEACEFUL && CarminiteGhastguard.m_217057_(entityType, (LevelAccessor)accessor, (MobSpawnType)type, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this) && !world.m_46855_(this.m_20191_());
    }

    public boolean m_21444_(BlockPos pos) {
        if (this.m_21535_() == -1.0f) {
            return true;
        }
        return pos.m_123342_() > this.m_9236_().m_141937_() + 64 && pos.m_123342_() < this.m_9236_().m_151558_() - 64 && this.m_21534_().m_123331_((Vec3i)pos) < (double)(this.m_21535_() * this.m_21535_());
    }

    public void m_7380_(CompoundTag compound) {
        this.saveHomePointToNbt(compound);
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadHomePointFromNbt(compound, 64);
    }

    @Override
    public BlockPos getRestrictionCenter() {
        return this.m_21534_();
    }

    @Override
    public void setRestriction(BlockPos pos, int dist) {
        this.m_21446_(pos, dist);
    }
}

