/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TwilightForestMod;
import twilightforest.entity.TFPart;
import twilightforest.entity.boss.Naga;

public class NagaSegment
extends TFPart<Naga> {
    public static final ResourceLocation RENDERER = TwilightForestMod.prefix("naga_segment");
    private int deathCounter;

    public NagaSegment(Naga naga) {
        super(naga);
        this.m_6034_(naga.m_20185_(), naga.m_20186_(), naga.m_20189_());
    }

    protected void m_8097_() {
        this.deactivate();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation renderer() {
        return RENDERER;
    }

    public boolean m_6469_(DamageSource src, float damage) {
        return !this.m_20145_() && ((Naga)this.getParent()).m_6469_(src, damage * 2.0f / 3.0f);
    }

    public boolean m_7306_(Entity entity) {
        return entity == this || entity == this.getParent();
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        ++this.f_19797_;
        if (!this.m_20145_()) {
            this.collideWithOthers();
        }
        if (this.deathCounter > 0) {
            --this.deathCounter;
            if (this.deathCounter <= 0) {
                Vec3 pos = this.m_20182_();
                float width = this.m_20205_();
                float height = this.m_20206_();
                for (int k = 0; k < 20; ++k) {
                    this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), pos.f_82479_ + (double)(this.f_19796_.m_188501_() * width * 2.0f) - (double)width, pos.f_82480_ + (double)(this.f_19796_.m_188501_() * height), pos.f_82481_ + (double)(this.f_19796_.m_188501_() * width * 2.0f) - (double)width, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02, this.f_19796_.m_188583_() * 0.02);
                }
                ((Naga)this.getParent()).m_6677_(this.m_269291_().m_269264_());
                ((Naga)this.getParent()).f_20919_ = 0;
                this.deactivate();
            }
        }
    }

    private void collideWithOthers() {
        List list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
        for (Entity entity : list) {
            if (!entity.m_6094_()) continue;
            this.collideWithEntity(entity);
        }
    }

    private void collideWithEntity(Entity entity) {
        entity.m_7334_((Entity)this);
        if (entity instanceof LivingEntity && !(entity instanceof Naga) && !((Naga)this.getParent()).isDazed()) {
            int attackStrength = 2;
            if (entity instanceof Animal) {
                attackStrength *= 3;
            }
            entity.m_6469_(entity.m_9236_().m_269111_().m_269333_((LivingEntity)this.getParent()), (float)attackStrength);
        }
    }

    public void deactivate() {
        this.setSize(EntityDimensions.m_20395_((float)0.0f, (float)0.0f));
        this.m_6842_(true);
    }

    public void activate() {
        this.setSize(EntityDimensions.m_20395_((float)1.8f, (float)1.8f));
        this.m_6842_(false);
    }

    public void m_19915_(float yaw, float pitch) {
        super.m_19915_(yaw, pitch);
    }

    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    public void selfDestruct(int counter) {
        this.deathCounter = counter;
    }

    public boolean m_6072_() {
        return false;
    }

    public float getStepHeight() {
        return 2.0f;
    }
}

