/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.boss.Hydra;
import twilightforest.entity.boss.HydraHead;
import twilightforest.entity.boss.HydraMortar;
import twilightforest.entity.boss.HydraNeck;
import twilightforest.entity.boss.HydraPart;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.ThrowPlayerPacket;

public class HydraHeadContainer {
    private static final int FLAME_BURN_FACTOR = 3;
    private static final int FLAME_DAMAGE = 19;
    private static final int BITE_DAMAGE = 48;
    private static double FLAME_BREATH_TRACKING_SPEED = 0.04;
    private static final State NEXT_AUTOMATIC = null;
    public final HydraHead headEntity;
    public final HydraNeck necka;
    public final HydraNeck neckb;
    public final HydraNeck neckc;
    public final HydraNeck neckd;
    public final HydraNeck necke;
    public Entity targetEntity;
    private double targetX;
    private double targetY;
    private double targetZ;
    private State prevState;
    private State currentState;
    private State nextState;
    public boolean isSecondaryAttacking;
    private int ticksNeeded;
    private int ticksProgress;
    private final int headNum;
    private int damageTaken;
    private int respawnCounter;
    private final Hydra hydra;
    private final Map<State, Float>[] stateNeckLength;
    private final Map<State, Float>[] stateXRotations;
    private final Map<State, Float>[] stateYRotations;
    private final Map<State, Float>[] stateMouthOpen;

    public HydraHeadContainer(Hydra hydra, int number, boolean startActive) {
        this.headNum = number;
        this.hydra = hydra;
        this.damageTaken = 0;
        this.respawnCounter = -1;
        this.headEntity = new HydraHead(hydra);
        this.headEntity.m_6034_(hydra.m_20185_(), hydra.m_20186_(), hydra.m_20189_());
        this.necka = new HydraNeck(this.headEntity);
        this.neckb = new HydraNeck(this.headEntity);
        this.neckc = new HydraNeck(this.headEntity);
        this.neckd = new HydraNeck(this.headEntity);
        this.necke = new HydraNeck(this.headEntity);
        this.stateNeckLength = new Map[this.hydra.numHeads];
        this.stateXRotations = new Map[this.hydra.numHeads];
        this.stateYRotations = new Map[this.hydra.numHeads];
        this.stateMouthOpen = new Map[this.hydra.numHeads];
        for (int i = 0; i < this.hydra.numHeads; ++i) {
            this.stateNeckLength[i] = new EnumMap<State, Float>(State.class);
            this.stateXRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateYRotations[i] = new EnumMap<State, Float>(State.class);
            this.stateMouthOpen[i] = new EnumMap<State, Float>(State.class);
        }
        this.setupStateRotations();
        if (startActive) {
            this.prevState = State.IDLE;
            this.currentState = State.IDLE;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 60;
            this.ticksProgress = 60;
        } else {
            this.prevState = State.DEAD;
            this.currentState = State.DEAD;
            this.nextState = NEXT_AUTOMATIC;
            this.ticksNeeded = 20;
            this.ticksProgress = 20;
        }
        this.setHeadPosition();
        this.setNeckPosition();
    }

    protected void setupStateRotations() {
        this.setAnimation(0, State.IDLE, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.IDLE, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.IDLE, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.IDLE, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.IDLE, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.IDLE, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.IDLE, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ATTACK_COOLDOWN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.ATTACK_COOLDOWN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.ATTACK_COOLDOWN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.ATTACK_COOLDOWN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.ATTACK_COOLDOWN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.ATTACK_COOLDOWN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.ATTACK_COOLDOWN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.FLAME_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.FLAME_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.FLAME_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.FLAME_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.FLAME_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.FLAME_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.FLAME_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.FLAMING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.FLAMING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.FLAMING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.FLAMING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.FLAMING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.FLAMING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.FLAMING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.FLAME_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.FLAME_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.FLAME_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.FLAME_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.FLAME_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.FLAME_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.FLAME_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.BITE_BEGINNING, -5.0f, 60.0f, 5.0f, 0.25f);
        this.setAnimation(1, State.BITE_BEGINNING, -10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.BITE_BEGINNING, -10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.BITE_READY, -5.0f, 60.0f, 5.0f, 1.0f);
        this.setAnimation(1, State.BITE_READY, -10.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.BITE_READY, -10.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.BITING, -5.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(1, State.BITING, -10.0f, -30.0f, 5.0f, 0.2f);
        this.setAnimation(2, State.BITING, -10.0f, 30.0f, 5.0f, 0.2f);
        this.setAnimation(0, State.BITE_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BITE_ENDING, -10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BITE_ENDING, -10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.MORTAR_BEGINNING, 50.0f, 0.0f, 8.0f, 0.75f);
        this.setAnimation(1, State.MORTAR_BEGINNING, 30.0f, 45.0f, 9.0f, 0.75f);
        this.setAnimation(2, State.MORTAR_BEGINNING, 30.0f, -45.0f, 9.0f, 0.75f);
        this.setAnimation(3, State.MORTAR_BEGINNING, 50.0f, 90.0f, 8.0f, 0.75f);
        this.setAnimation(4, State.MORTAR_BEGINNING, 50.0f, -90.0f, 8.0f, 0.75f);
        this.setAnimation(5, State.MORTAR_BEGINNING, -10.0f, 90.0f, 9.0f, 0.75f);
        this.setAnimation(6, State.MORTAR_BEGINNING, -10.0f, -90.0f, 9.0f, 0.75f);
        this.setAnimation(0, State.MORTAR_SHOOTING, 45.0f, 0.0f, 8.0f, 1.0f);
        this.setAnimation(1, State.MORTAR_SHOOTING, 30.0f, 60.0f, 9.0f, 1.0f);
        this.setAnimation(2, State.MORTAR_SHOOTING, 30.0f, -60.0f, 9.0f, 1.0f);
        this.setAnimation(3, State.MORTAR_SHOOTING, 50.0f, 90.0f, 8.0f, 1.0f);
        this.setAnimation(4, State.MORTAR_SHOOTING, 50.0f, -90.0f, 8.0f, 1.0f);
        this.setAnimation(5, State.MORTAR_SHOOTING, -10.0f, 90.0f, 9.0f, 1.0f);
        this.setAnimation(6, State.MORTAR_SHOOTING, -10.0f, -90.0f, 9.0f, 1.0f);
        this.setAnimation(0, State.MORTAR_ENDING, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.MORTAR_ENDING, 10.0f, 45.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.MORTAR_ENDING, 10.0f, -45.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.MORTAR_ENDING, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.MORTAR_ENDING, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.MORTAR_ENDING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.MORTAR_ENDING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DYING, -20.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.DYING, -20.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.DYING, -20.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.DYING, -20.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.DYING, -20.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.DYING, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.DYING, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(1, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(2, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(3, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(4, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(5, State.DEAD, 0.0f, 179.0f, 4.0f, 0.0f);
        this.setAnimation(6, State.DEAD, 0.0f, -180.0f, 4.0f, 0.0f);
        this.setAnimation(0, State.BORN, 60.0f, 0.0f, 7.0f, 0.0f);
        this.setAnimation(1, State.BORN, 10.0f, 60.0f, 9.0f, 0.0f);
        this.setAnimation(2, State.BORN, 10.0f, -60.0f, 9.0f, 0.0f);
        this.setAnimation(3, State.BORN, 50.0f, 90.0f, 8.0f, 0.0f);
        this.setAnimation(4, State.BORN, 50.0f, -90.0f, 8.0f, 0.0f);
        this.setAnimation(5, State.BORN, -10.0f, 90.0f, 9.0f, 0.0f);
        this.setAnimation(6, State.BORN, -10.0f, -90.0f, 9.0f, 0.0f);
        this.setAnimation(0, State.ROAR_START, 60.0f, 0.0f, 7.0f, 0.25f);
        this.setAnimation(1, State.ROAR_START, 10.0f, 60.0f, 9.0f, 0.25f);
        this.setAnimation(2, State.ROAR_START, 10.0f, -60.0f, 9.0f, 0.25f);
        this.setAnimation(3, State.ROAR_START, 50.0f, 90.0f, 8.0f, 0.25f);
        this.setAnimation(4, State.ROAR_START, 50.0f, -90.0f, 8.0f, 0.25f);
        this.setAnimation(5, State.ROAR_START, -10.0f, 90.0f, 9.0f, 0.25f);
        this.setAnimation(6, State.ROAR_START, -10.0f, -90.0f, 9.0f, 0.25f);
        this.setAnimation(0, State.ROAR_RAWR, 60.0f, 0.0f, 9.0f, 1.0f);
        this.setAnimation(1, State.ROAR_RAWR, 10.0f, 60.0f, 11.0f, 1.0f);
        this.setAnimation(2, State.ROAR_RAWR, 10.0f, -60.0f, 11.0f, 1.0f);
        this.setAnimation(3, State.ROAR_RAWR, 50.0f, 90.0f, 10.0f, 1.0f);
        this.setAnimation(4, State.ROAR_RAWR, 50.0f, -90.0f, 10.0f, 1.0f);
        this.setAnimation(5, State.ROAR_RAWR, -10.0f, 90.0f, 11.0f, 1.0f);
        this.setAnimation(6, State.ROAR_RAWR, -10.0f, -90.0f, 11.0f, 1.0f);
    }

    private void setAnimation(int head, State state, float xRotation, float yRotation, float neckLength, float mouthOpen) {
        this.stateXRotations[head].put(state, Float.valueOf(xRotation));
        this.stateYRotations[head].put(state, Float.valueOf(yRotation));
        this.stateNeckLength[head].put(state, Float.valueOf(neckLength));
        this.stateMouthOpen[head].put(state, Float.valueOf(mouthOpen));
    }

    public HydraNeck[] getNeckArray() {
        return new HydraNeck[]{this.necka, this.neckb, this.neckc, this.neckd, this.necke};
    }

    public void tick() {
        this.headEntity.m_8119_();
        this.necka.m_8119_();
        this.neckb.m_8119_();
        this.neckc.m_8119_();
        this.neckd.m_8119_();
        this.necke.m_8119_();
        this.setDifficultyVariables();
        if (!this.hydra.m_9236_().m_5776_()) {
            if (this.isActive() && this.headEntity.f_19815_.f_20377_ == 0.0f) {
                this.headEntity.activate();
                this.necka.activate();
                this.neckb.activate();
                this.neckc.activate();
                this.neckd.activate();
                this.necke.activate();
            } else if (!this.isActive() && this.headEntity.f_19815_.f_20377_ > 0.0f) {
                this.headEntity.deactivate();
                this.necka.deactivate();
                this.neckb.deactivate();
                this.neckc.deactivate();
                this.neckd.deactivate();
                this.necke.deactivate();
            }
            this.advanceRespawnCounter();
            this.advanceHeadState();
            this.setHeadPosition();
            this.setHeadFacing();
            this.executeAttacks();
            this.playSounds();
        } else {
            this.clientAnimateHeadDeath();
            this.addMouthParticles();
        }
        this.setNeckPosition();
    }

    public boolean canRespawn() {
        return this.currentState == State.DEAD && this.respawnCounter == -1;
    }

    private void advanceRespawnCounter() {
        if (this.currentState == State.DEAD && this.respawnCounter > -1 && --this.respawnCounter <= 0) {
            this.setNextState(State.BORN);
            this.damageTaken = 0;
            this.endCurrentAction();
            this.respawnCounter = -1;
        }
    }

    private void clientAnimateHeadDeath() {
        if (this.headEntity.getState() == State.DYING) {
            ++this.headEntity.deathTime;
            if (this.headEntity.deathTime > 0) {
                if (this.headEntity.deathTime < 20) {
                    this.doExplosionOn(this.headEntity, true);
                } else if (this.headEntity.deathTime < 30) {
                    this.doExplosionOn(this.necka, false);
                } else if (this.headEntity.deathTime < 40) {
                    this.doExplosionOn(this.neckb, false);
                } else if (this.headEntity.deathTime < 50) {
                    this.doExplosionOn(this.neckc, false);
                } else if (this.headEntity.deathTime < 60) {
                    this.doExplosionOn(this.neckd, false);
                } else if (this.headEntity.deathTime < 70) {
                    this.doExplosionOn(this.necke, false);
                }
            }
            this.necka.hurtTime = 20;
            this.neckb.hurtTime = 20;
            this.neckc.hurtTime = 20;
            this.neckd.hurtTime = 20;
            this.necke.hurtTime = 20;
        } else {
            this.headEntity.deathTime = 0;
            Objects.requireNonNull(this.headEntity);
            this.headEntity.health = 1000.0f;
        }
    }

    private void doExplosionOn(HydraPart part, boolean large) {
        for (int i = 0; i < 5; ++i) {
            double vx = part.m_9236_().m_213780_().m_188583_() * 0.02;
            double vy = part.m_9236_().m_213780_().m_188583_() * 0.02;
            double vz = part.m_9236_().m_213780_().m_188583_() * 0.02;
            part.m_9236_().m_7106_((ParticleOptions)(part.m_9236_().m_213780_().m_188503_(5) == 0 || large ? ParticleTypes.f_123813_ : ParticleTypes.f_123759_), part.m_20185_() + (double)(part.m_9236_().m_213780_().m_188501_() * 2.0f), part.m_20186_() + (double)(part.m_9236_().m_213780_().m_188501_() * 2.0f), part.m_20189_() + (double)(part.m_9236_().m_213780_().m_188501_() * 2.0f), vx, vy, vz);
        }
    }

    private void advanceHeadState() {
        if (++this.ticksProgress >= this.ticksNeeded) {
            State myNext;
            if (this.nextState == NEXT_AUTOMATIC) {
                myNext = State.NEXT_STATE.get((Object)this.currentState);
                if (myNext != this.currentState && this.isSecondaryAttacking && myNext == State.ATTACK_COOLDOWN) {
                    this.isSecondaryAttacking = false;
                    myNext = State.IDLE;
                }
            } else {
                myNext = this.nextState;
                this.nextState = NEXT_AUTOMATIC;
            }
            this.ticksNeeded = myNext.duration;
            this.ticksProgress = 0;
            this.prevState = this.currentState;
            this.currentState = myNext;
        }
        if (this.headEntity.getState() != this.currentState) {
            this.headEntity.setState(this.currentState);
        }
    }

    private void setHeadFacing() {
        if (this.currentState == State.BITE_READY) {
            float yawOffOffset;
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.m_8132_());
            float biteMaxYaw = -60.0f;
            float biteMinYaw = -90.0f;
            if (this.headNum == 2) {
                biteMaxYaw = 60.0f;
                biteMinYaw = 90.0f;
            }
            if ((yawOffOffset = Mth.m_14177_((float)(this.headEntity.m_146908_() - this.hydra.f_20883_))) > biteMaxYaw) {
                this.headEntity.m_146922_(this.hydra.f_20883_ + biteMaxYaw);
            }
            if (yawOffOffset < biteMinYaw) {
                this.headEntity.m_146922_(this.hydra.f_20883_ + biteMinYaw);
            }
            Vec3 look = this.headEntity.m_20154_();
            double distance = 16.0;
            this.targetX = this.headEntity.m_20185_() + look.m_7096_() * distance;
            this.targetY = this.headEntity.m_20186_() + 1.5 + look.m_7098_() * distance;
            this.targetZ = this.headEntity.m_20189_() + look.m_7094_() * distance;
        } else if (this.currentState == State.BITING || this.currentState == State.BITE_ENDING) {
            this.faceEntity(this.targetEntity, 5.0f, this.hydra.m_8132_());
            this.headEntity.m_146926_((float)((double)this.headEntity.m_146909_() + 0.7853981633974483));
        } else if (this.currentState == State.ROAR_RAWR) {
            this.faceVec(this.targetX, this.targetY, this.targetZ, 10.0f, this.hydra.m_8132_());
        } else if (this.currentState == State.FLAMING || this.currentState == State.FLAME_BEGINNING) {
            this.moveTargetCoordsTowardsTargetEntity(FLAME_BREATH_TRACKING_SPEED);
            this.faceVec(this.targetX, this.targetY, this.targetZ, 5.0f, this.hydra.m_8132_());
        } else if (this.isActive()) {
            if (this.targetEntity != null) {
                this.faceEntity(this.targetEntity, 5.0f, this.hydra.m_8132_());
            } else {
                this.faceIdle(1.5f, this.hydra.m_8132_());
            }
        }
    }

    private void moveTargetCoordsTowardsTargetEntity(double distance) {
        if (this.targetEntity != null) {
            Vec3 vect = new Vec3(this.targetEntity.m_20185_() - this.targetX, this.targetEntity.m_20186_() - this.targetY, this.targetEntity.m_20189_() - this.targetZ);
            vect = vect.m_82541_();
            this.targetX += vect.m_7096_() * distance;
            this.targetY += vect.m_7098_() * distance;
            this.targetZ += vect.m_7094_() * distance;
        }
    }

    private void addMouthParticles() {
        Vec3 vector = this.headEntity.m_20154_();
        double dist = 3.5;
        double px = this.headEntity.m_20185_() + vector.m_7096_() * dist;
        double py = this.headEntity.m_20186_() + 1.0 + vector.m_7098_() * dist;
        double pz = this.headEntity.m_20189_() + vector.m_7094_() * dist;
        if (this.headEntity.getState() == State.FLAME_BEGINNING) {
            this.headEntity.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123744_, px + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, py + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, pz + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, 0.0, 0.0, 0.0);
            this.headEntity.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123762_, px + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, py + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, pz + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.FLAMING) {
            Vec3 look = this.headEntity.m_20154_();
            for (int i = 0; i < 5; ++i) {
                double dx = look.m_7096_();
                double dy = look.m_7098_();
                double dz = look.m_7094_();
                double spread = 5.0 + this.headEntity.m_9236_().m_213780_().m_188500_() * 2.5;
                double velocity = 1.0 + this.headEntity.m_9236_().m_213780_().m_188500_();
                dx += this.headEntity.m_9236_().m_213780_().m_188583_() * 0.0075 * spread;
                dy += this.headEntity.m_9236_().m_213780_().m_188583_() * 0.0075 * spread;
                dz += this.headEntity.m_9236_().m_213780_().m_188583_() * 0.0075 * spread;
                this.headEntity.m_9236_().m_7107_((ParticleOptions)TFParticleType.LARGE_FLAME.get(), px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
            }
        }
        if (this.headEntity.getState() == State.BITE_BEGINNING || this.headEntity.getState() == State.BITE_READY) {
            this.headEntity.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123769_, px + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, py + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, pz + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
        if (this.headEntity.getState() == State.MORTAR_BEGINNING) {
            this.headEntity.m_9236_().m_7107_((ParticleOptions)ParticleTypes.f_123755_, px + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, py + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, pz + this.headEntity.m_9236_().m_213780_().m_188500_() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    private void playSounds() {
        if (this.headEntity.getState() == State.FLAMING && this.headEntity.f_19797_ % 5 == 0) {
            this.headEntity.m_5496_((SoundEvent)TFSounds.HYDRA_SHOOT_FIRE.get(), 0.5f + this.headEntity.m_9236_().m_213780_().m_188501_(), this.headEntity.m_9236_().m_213780_().m_188501_() * 0.7f + 0.3f);
            this.headEntity.m_146850_(GameEvent.f_157778_);
        }
        if (this.headEntity.getState() == State.ROAR_RAWR) {
            this.headEntity.m_5496_((SoundEvent)TFSounds.HYDRA_ROAR.get(), 1.25f, this.headEntity.m_9236_().m_213780_().m_188501_() * 0.3f + 0.7f);
            this.headEntity.m_146850_(GameEvent.f_223709_);
        }
        if (this.headEntity.getState() == State.BITE_READY && this.ticksProgress == 60) {
            this.headEntity.m_5496_((SoundEvent)TFSounds.HYDRA_WARN.get(), 2.0f, this.headEntity.m_9236_().m_213780_().m_188501_() * 0.3f + 0.7f);
        }
    }

    protected void setNeckPosition() {
        Vec3 vector = null;
        float neckRotation = 0.0f;
        if (this.headNum == 0) {
            vector = new Vec3(0.0, 3.0, -1.0);
            neckRotation = 0.0f;
        }
        if (this.headNum == 1) {
            vector = new Vec3(-1.0, 3.0, 3.0);
            neckRotation = 90.0f;
        }
        if (this.headNum == 2) {
            vector = new Vec3(1.0, 3.0, 3.0);
            neckRotation = -90.0f;
        }
        if (this.headNum == 3) {
            vector = new Vec3(-1.0, 3.0, 3.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 4) {
            vector = new Vec3(1.0, 3.0, 3.0);
            neckRotation = -135.0f;
        }
        if (this.headNum == 5) {
            vector = new Vec3(-1.0, 3.0, 5.0);
            neckRotation = 135.0f;
        }
        if (this.headNum == 6) {
            vector = new Vec3(1.0, 3.0, 5.0);
            neckRotation = -135.0f;
        }
        vector = vector.m_82524_(-(this.hydra.f_20883_ + neckRotation) * (float)Math.PI / 180.0f);
        this.setNeckPosition(this.hydra.m_20185_() + vector.m_7096_(), this.hydra.m_20186_() + vector.m_7098_(), this.hydra.m_20189_() + vector.m_7094_(), this.hydra.f_20883_);
    }

    protected void setHeadPosition() {
        float periodX;
        float neckLength = this.getCurrentNeckLength();
        float xRotation = this.getCurrentHeadXRotation();
        float yRotation = this.getCurrentHeadYRotation();
        float f = this.headNum == 0 || this.headNum == 3 ? 20.0f : (periodX = this.headNum == 1 || this.headNum == 4 ? 5.0f : 7.0f);
        float periodY = this.headNum == 0 || this.headNum == 4 ? 10.0f : (this.headNum == 1 || this.headNum == 6 ? 6.0f : 5.0f);
        float xSwing = Mth.m_14031_((float)((float)this.hydra.f_19797_ / periodX)) * 3.0f;
        float ySwing = Mth.m_14031_((float)((float)this.hydra.f_19797_ / periodY)) * 5.0f;
        if (!this.isActive()) {
            ySwing = 0.0f;
            xSwing = 0.0f;
        }
        Vec3 vector = new Vec3(0.0, 0.0, (double)neckLength);
        vector = vector.m_82496_((xRotation * (float)Math.PI + xSwing) / 180.0f);
        vector = vector.m_82524_(-(this.hydra.f_20883_ + yRotation + ySwing) * (float)Math.PI / 180.0f);
        double dx = this.hydra.m_20185_() + vector.m_7096_();
        double dy = this.hydra.m_20186_() + vector.m_7098_() + 3.0;
        double dz = this.hydra.m_20189_() + vector.m_7094_();
        this.headEntity.m_6034_(dx, dy, dz);
        this.headEntity.setMouthOpen(this.getCurrentMouthOpen());
    }

    private void executeAttacks() {
        Entity target;
        if (this.currentState == State.MORTAR_SHOOTING && this.ticksProgress % 10 == 0) {
            HydraMortar mortar = new HydraMortar((EntityType<? extends HydraMortar>)((EntityType)TFEntities.HYDRA_MORTAR.get()), this.headEntity.m_9236_(), this.headEntity);
            if (this.targetEntity != null && !this.headEntity.canEntityBeSeen(this.targetEntity)) {
                mortar.setToBlasting();
            }
            this.headEntity.m_5496_((SoundEvent)TFSounds.HYDRA_SHOOT.get(), 10.0f, (this.headEntity.m_9236_().m_213780_().m_188501_() - this.headEntity.m_9236_().m_213780_().m_188501_()) * 0.2f + 1.0f);
            this.headEntity.m_9236_().m_7967_((Entity)mortar);
        }
        if (this.headEntity.getState() == State.BITING) {
            List nearbyList = this.headEntity.m_9236_().m_45933_((Entity)this.headEntity, this.headEntity.m_20191_().m_82377_(0.0, 1.0, 0.0));
            for (Entity nearby : nearbyList) {
                Player player;
                if (!(nearby instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)nearby;
                if (nearby == this.hydra) continue;
                if (nearby instanceof Player && (player = (Player)nearby).m_6117_() && player.m_21211_().m_41720_().canPerformAction(player.m_21211_(), ToolActions.SHIELD_BLOCK)) {
                    if (!player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                        this.headEntity.m_9236_().m_5594_(null, player.m_20183_(), player.m_21211_().m_150930_(Items.f_42740_) ? (SoundEvent)TFSounds.WOOD_SHIELD_SHATTERS.get() : (SoundEvent)TFSounds.METAL_SHIELD_SHATTERS.get(), SoundSource.PLAYERS, 1.0f, player.m_6100_());
                        player.m_21211_().m_41622_(112, (LivingEntity)player, event -> event.m_21190_(player.m_7655_()));
                    }
                    player.m_36335_().m_41524_(player.m_21211_().m_41720_(), 200);
                    TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ThrowPlayerPacket((float)(-this.headEntity.m_6350_().m_122429_()) * 0.5f, 0.15f, (float)(-this.headEntity.m_6350_().m_122431_()) * 0.5f));
                }
                nearby.m_6469_(TFDamageTypes.getDamageSource(living.m_9236_(), TFDamageTypes.HYDRA_BITE, (EntityType)TFEntities.HYDRA.get()), 48.0f);
                if (living instanceof Player) {
                    player = (Player)living;
                    TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ThrowPlayerPacket((float)(-this.headEntity.m_6350_().m_122429_()) * 0.5f, 0.1f, (float)(-this.headEntity.m_6350_().m_122431_()) * 0.5f));
                    continue;
                }
                living.m_147240_((double)(-this.headEntity.m_6350_().m_122429_()), (double)0.1f, (double)(-this.headEntity.m_6350_().m_122431_()));
            }
        }
        if (!(this.headEntity.getState() != State.FLAMING || (target = this.getHeadLookTarget()) == null || target == this.headEntity.getParent() || target instanceof HydraPart && ((HydraPart)target).getParent() == this.headEntity.getParent() || target.m_5825_() || !target.m_6469_(TFDamageTypes.getDamageSource(target.m_9236_(), TFDamageTypes.HYDRA_FIRE, (EntityType)TFEntities.HYDRA.get()), 19.0f))) {
            target.m_20254_(3);
        }
    }

    private void setDifficultyVariables() {
        FLAME_BREATH_TRACKING_SPEED = this.hydra.m_9236_().m_46791_() != Difficulty.HARD ? 0.04 : 0.1;
    }

    @Nullable
    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3 srcVec = new Vec3(this.headEntity.m_20185_(), this.headEntity.m_20186_() + 1.0, this.headEntity.m_20189_());
        Vec3 lookVec = this.headEntity.m_20252_(1.0f);
        BlockHitResult raytrace = this.headEntity.m_9236_().m_45547_(new ClipContext(srcVec, srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this.headEntity));
        BlockPos hitpos = raytrace != null ? raytrace.m_82425_() : null;
        double rx = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.m_20185_() - (double)hitpos.m_123341_()));
        double ry = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.m_20186_() - (double)hitpos.m_123342_()));
        double rz = hitpos == null ? range : Math.min(range, Math.abs(this.headEntity.m_20189_() - (double)hitpos.m_123343_()));
        Vec3 destVec = srcVec.m_82520_(lookVec.m_7096_() * range, lookVec.m_7098_() * range, lookVec.m_7094_() * range);
        float var9 = 3.0f;
        List possibleList = this.headEntity.m_9236_().m_45933_((Entity)this.headEntity, this.headEntity.m_20191_().m_82386_(lookVec.m_7096_() * rx, lookVec.m_7098_() * ry, lookVec.m_7094_() * rz).m_82377_((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.m_6087_() || possibleEntity == this.headEntity || possibleEntity == this.necka || possibleEntity == this.neckb || possibleEntity == this.neckc) continue;
            float borderSize = possibleEntity.m_6143_();
            AABB collisionBB = possibleEntity.m_20191_().m_82377_((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.m_82371_(srcVec, destVec);
            if (collisionBB.m_82390_(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.m_82554_((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void setNextState(State next) {
        this.nextState = next;
    }

    public void endCurrentAction() {
        this.ticksProgress = this.ticksNeeded;
    }

    private float getCurrentNeckLength() {
        float prevLength = this.stateNeckLength[this.headNum].get((Object)this.prevState).floatValue();
        float curLength = this.stateNeckLength[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.m_144920_((float)prevLength, (float)curLength, (float)progress);
    }

    private float getCurrentHeadXRotation() {
        float prevRotation = this.stateXRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateXRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.m_144920_((float)prevRotation, (float)currentRotation, (float)progress);
    }

    private float getCurrentHeadYRotation() {
        float prevRotation = this.stateYRotations[this.headNum].get((Object)this.prevState).floatValue();
        float currentRotation = this.stateYRotations[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.m_144920_((float)prevRotation, (float)currentRotation, (float)progress);
    }

    protected float getCurrentMouthOpen() {
        float prevOpen = this.stateMouthOpen[this.headNum].get((Object)this.prevState).floatValue();
        float curOpen = this.stateMouthOpen[this.headNum].get((Object)this.currentState).floatValue();
        float progress = (float)this.ticksProgress / (float)this.ticksNeeded;
        return Mth.m_144920_((float)prevOpen, (float)curOpen, (float)progress);
    }

    protected void setNeckPosition(double startX, double startY, double startZ, float startYaw) {
        double endX = this.headEntity.m_20185_();
        double endY = this.headEntity.m_20186_();
        double endZ = this.headEntity.m_20189_();
        float endYaw = this.headEntity.m_146908_();
        float endPitch = this.headEntity.m_146909_();
        while (startYaw - endYaw < -180.0f) {
            endYaw -= 360.0f;
        }
        while (startYaw - endYaw >= 180.0f) {
            endYaw += 360.0f;
        }
        while (0.0f - endPitch < -180.0f) {
            endPitch -= 360.0f;
        }
        while (0.0f - endPitch >= 180.0f) {
            endPitch += 360.0f;
        }
        if (endPitch > 0.0f) {
            vector = new Vec3(0.0, 0.0, -1.0).m_82524_(-endYaw * 3.141593f / 180.0f);
            endX += vector.m_7096_();
            endY += vector.m_7098_();
            endZ += vector.m_7094_();
        } else {
            vector = this.headEntity.m_20154_();
            float dist = 1.0f;
            endX -= vector.m_7096_() * (double)dist;
            endY -= vector.m_7098_() * (double)dist;
            endZ -= vector.m_7094_() * (double)dist;
        }
        float factor = 0.0f;
        this.necka.m_6034_(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necka.m_146922_(endYaw + (startYaw - endYaw) * factor);
        this.necka.m_146926_(endPitch + (0.0f - endPitch) * factor);
        factor = 0.25f;
        this.neckb.m_6034_(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckb.m_146922_(endYaw + (startYaw - endYaw) * factor);
        this.neckb.m_146926_(endPitch + (0.0f - endPitch) * factor);
        factor = 0.5f;
        this.neckc.m_6034_(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckc.m_146922_(endYaw + (startYaw - endYaw) * factor);
        this.neckc.m_146926_(endPitch + (0.0f - endPitch) * factor);
        factor = 0.75f;
        this.neckd.m_6034_(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.neckd.m_146922_(endYaw + (startYaw - endYaw) * factor);
        this.neckd.m_146926_(endPitch + (0.0f - endPitch) * factor);
        factor = 1.0f;
        this.necke.m_6034_(endX + (startX - endX) * (double)factor, endY + (startY - endY) * (double)factor, endZ + (startZ - endZ) * (double)factor);
        this.necke.m_146922_(endYaw + (startYaw - endYaw) * factor);
        this.necke.m_146926_(endPitch + (0.0f - endPitch) * factor);
    }

    private void faceIdle(float yawConstraint, float pitchConstraint) {
        float angle = this.hydra.m_146908_() * 3.141593f / 180.0f;
        float distance = 30.0f;
        double dx = this.hydra.m_20185_() - (double)(Mth.m_14031_((float)angle) * distance);
        double dy = this.hydra.m_20186_() + 3.0;
        double dz = this.hydra.m_20189_() + (double)(Mth.m_14089_((float)angle) * distance);
        this.faceVec(dx, dy, dz, yawConstraint, pitchConstraint);
    }

    public void faceEntity(Entity entity, float yawConstraint, float pitchConstraint) {
        double yTarget;
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            yTarget = entityliving.m_20186_() + (double)entityliving.m_20192_();
        } else {
            yTarget = (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0;
        }
        this.faceVec(entity.m_20185_(), yTarget, entity.m_20189_(), yawConstraint, pitchConstraint);
        this.targetX = entity.m_20185_();
        this.targetY = entity.m_20186_();
        this.targetZ = entity.m_20189_();
    }

    private void faceVec(double x, double y, double z, float yawConstraint, float pitchConstraint) {
        double xOffset = x - this.headEntity.m_20185_();
        double zOffset = z - this.headEntity.m_20189_();
        double yOffset = this.headEntity.m_20186_() + 1.0 - y;
        double distance = Mth.m_14116_((float)((float)(xOffset * xOffset + zOffset * zOffset)));
        float xyAngle = (float)(Math.atan2(zOffset, xOffset) * 180.0 / Math.PI) - 90.0f;
        float zdAngle = (float)(-(Math.atan2(yOffset, distance) * 180.0 / Math.PI));
        this.headEntity.m_146926_(-this.updateRotation(this.headEntity.m_146909_(), zdAngle, pitchConstraint));
        this.headEntity.m_146922_(this.updateRotation(this.headEntity.m_146908_(), xyAngle, yawConstraint));
    }

    private float updateRotation(float current, float intended, float increment) {
        float delta = Mth.m_14177_((float)(intended - current));
        if (delta > increment) {
            delta = increment;
        }
        if (delta < -increment) {
            delta = -increment;
        }
        return Mth.m_14177_((float)(current + delta));
    }

    public void setTargetEntity(@Nullable Entity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setHurtTime(int hurtTime) {
        if (this.headEntity != null) {
            this.headEntity.hurtTime = hurtTime;
        }
        this.necka.hurtTime = hurtTime;
        this.neckb.hurtTime = hurtTime;
        this.neckc.hurtTime = hurtTime;
        this.neckd.hurtTime = hurtTime;
        this.necke.hurtTime = hurtTime;
    }

    public boolean shouldRenderHead() {
        return this.headEntity.getState() != State.DEAD && this.headEntity.deathTime < 20;
    }

    public boolean isActive() {
        return this.currentState != State.DYING && this.currentState != State.DEAD;
    }

    public boolean isIdle() {
        return this.currentState == State.IDLE && (this.nextState == NEXT_AUTOMATIC || this.nextState == State.IDLE);
    }

    public boolean isAttacking() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.currentState == State.FLAME_BEGINNING || this.currentState == State.FLAMING || this.currentState == State.MORTAR_BEGINNING || this.currentState == State.MORTAR_SHOOTING;
    }

    public boolean isBiting() {
        return this.currentState == State.BITE_BEGINNING || this.currentState == State.BITE_READY || this.currentState == State.BITING || this.nextState == State.BITE_BEGINNING;
    }

    public void addDamage(float damageAmount) {
        this.damageTaken = (int)((float)this.damageTaken + damageAmount);
    }

    public int getDamageTaken() {
        return this.damageTaken;
    }

    public void setRespawnCounter(int count) {
        this.respawnCounter = count;
    }

    static enum State {
        IDLE(10),
        BITE_BEGINNING(40),
        BITE_READY(80),
        BITING(7),
        BITE_ENDING(40),
        FLAME_BEGINNING(40),
        FLAMING(100),
        FLAME_ENDING(30),
        MORTAR_BEGINNING(40),
        MORTAR_SHOOTING(25),
        MORTAR_ENDING(30),
        DYING(70),
        DEAD(20),
        ATTACK_COOLDOWN(80),
        BORN(20),
        ROAR_START(10),
        ROAR_RAWR(50);

        private static final Map<State, State> NEXT_STATE;
        public final int duration;

        private State(int duration) {
            this.duration = duration;
        }

        static {
            EnumMap<State, State> b = new EnumMap<State, State>(State.class);
            b.put(IDLE, IDLE);
            b.put(BITE_BEGINNING, BITE_READY);
            b.put(BITE_READY, BITING);
            b.put(BITING, BITE_ENDING);
            b.put(BITE_ENDING, ATTACK_COOLDOWN);
            b.put(FLAME_BEGINNING, FLAMING);
            b.put(FLAMING, FLAME_ENDING);
            b.put(FLAME_ENDING, ATTACK_COOLDOWN);
            b.put(MORTAR_BEGINNING, MORTAR_SHOOTING);
            b.put(MORTAR_SHOOTING, MORTAR_ENDING);
            b.put(MORTAR_ENDING, ATTACK_COOLDOWN);
            b.put(ATTACK_COOLDOWN, IDLE);
            b.put(DYING, DEAD);
            b.put(DEAD, DEAD);
            b.put(BORN, ROAR_START);
            b.put(ROAR_START, ROAR_RAWR);
            b.put(ROAR_RAWR, IDLE);
            NEXT_STATE = ImmutableMap.copyOf(b);
        }
    }
}

