/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai.goal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import twilightforest.entity.boss.UrGhast;

public class UrGhastFlightGoal
extends Goal {
    private static final int HOVER_ALTITUDE = 20;
    private final UrGhast ghast;
    private List<BlockPos> pointsToVisit;
    private int currentPoint = 0;

    public UrGhastFlightGoal(UrGhast ghast) {
        this.ghast = ghast;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        double d2;
        double d1;
        MoveControl entitymovehelper = this.ghast.m_21566_();
        this.pointsToVisit = this.createPath();
        if (this.pointsToVisit.isEmpty()) {
            return false;
        }
        if (!entitymovehelper.m_24995_()) {
            return true;
        }
        double d0 = entitymovehelper.m_25000_() - this.ghast.m_20185_();
        double d3 = d0 * d0 + (d1 = entitymovehelper.m_25001_() - this.ghast.m_20186_()) * d1 + (d2 = entitymovehelper.m_25002_() - this.ghast.m_20189_()) * d2;
        return d3 < 1.0 || d3 > 3600.0;
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        if (this.pointsToVisit.isEmpty()) {
            this.pointsToVisit.addAll(this.createPath());
        } else {
            if (this.currentPoint >= this.pointsToVisit.size()) {
                this.currentPoint = 0;
                if (!this.ghast.checkGhastsAtTraps()) {
                    this.ghast.spawnGhastsAtTraps();
                }
            }
            double x = this.pointsToVisit.get(this.currentPoint).m_123341_();
            double y = this.pointsToVisit.get(this.currentPoint).m_123342_() + (this.ghast.m_21536_() ? 20 : 0);
            double z = this.pointsToVisit.get(this.currentPoint).m_123343_();
            this.ghast.m_21566_().m_6849_(x, y, z, 1.0);
            ++this.currentPoint;
            this.ghast.f_19794_ = false;
        }
    }

    private List<BlockPos> createPath() {
        ArrayList<BlockPos> potentialPoints = new ArrayList<BlockPos>();
        BlockPos pos = new BlockPos((Vec3i)this.ghast.getLogicalScanPoint());
        if (!this.ghast.getTrapLocations().isEmpty()) {
            potentialPoints.addAll(this.ghast.getTrapLocations());
        } else {
            potentialPoints.add(pos.m_7918_(20, 0, 0));
            potentialPoints.add(pos.m_7918_(0, 0, -20));
            potentialPoints.add(pos.m_7918_(-20, 0, 0));
            potentialPoints.add(pos.m_7918_(0, 0, 20));
        }
        Collections.shuffle(potentialPoints);
        if (this.ghast.getTrapLocations().isEmpty()) {
            potentialPoints.add(pos);
        }
        return potentialPoints;
    }
}

