/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.TwilightBoat;
import twilightforest.init.TFEntities;
import twilightforest.init.TFItems;

public class TwilightChestBoat
extends TwilightBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public TwilightChestBoat(EntityType<? extends TwilightBoat> type, Level level) {
        super(type, level);
    }

    public TwilightChestBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends TwilightBoat>)((EntityType)TFEntities.CHEST_BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected float m_213802_() {
        return 0.15f;
    }

    protected int m_213801_() {
        return 1;
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.m_219943_(tag);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_219934_(tag);
    }

    public void m_213560_(DamageSource damageSource) {
        super.m_213560_(damageSource);
        this.m_219927_(damageSource, this.m_9236_(), (Entity)this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().m_5776_() && reason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(reason);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_7310_((Entity)player) && !player.m_36341_()) {
            return super.m_6096_(player, hand);
        }
        InteractionResult interactionresult = this.m_268996_(player);
        if (interactionresult.m_19077_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return interactionresult;
    }

    public void m_213583_(Player player) {
        player.m_5893_((MenuProvider)this);
        if (!player.m_9236_().m_5776_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    @Override
    public Item m_38369_() {
        return switch (this.getTwilightBoatType()) {
            default -> throw new IncompatibleClassChangeError();
            case TwilightBoat.Type.TWILIGHT_OAK -> (Item)TFItems.TWILIGHT_OAK_CHEST_BOAT.get();
            case TwilightBoat.Type.CANOPY -> (Item)TFItems.CANOPY_CHEST_BOAT.get();
            case TwilightBoat.Type.MANGROVE -> (Item)TFItems.MANGROVE_CHEST_BOAT.get();
            case TwilightBoat.Type.DARKWOOD -> (Item)TFItems.DARKWOOD_CHEST_BOAT.get();
            case TwilightBoat.Type.TIME -> (Item)TFItems.TIME_CHEST_BOAT.get();
            case TwilightBoat.Type.TRANSFORMATION -> (Item)TFItems.TRANSFORMATION_CHEST_BOAT.get();
            case TwilightBoat.Type.MINING -> (Item)TFItems.MINING_CHEST_BOAT.get();
            case TwilightBoat.Type.SORTING -> (Item)TFItems.SORTING_CHEST_BOAT.get();
        };
    }

    public void m_6211_() {
        this.m_219953_();
    }

    public int m_6643_() {
        return 27;
    }

    public ItemStack m_8020_(int index) {
        return this.m_219947_(index);
    }

    public ItemStack m_7407_(int index, int amount) {
        return this.m_219936_(index, amount);
    }

    public ItemStack m_8016_(int index) {
        return this.m_219945_(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.m_219940_(index, stack);
    }

    public SlotAccess m_141942_(int index) {
        return this.m_219951_(index);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return this.m_219954_(player);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.lootTable != null && player.m_5833_()) {
            return null;
        }
        this.unpackLootTable(inventory.f_35978_);
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player player) {
        this.m_219949_(player);
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation location) {
        this.lootTable = location;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long seed) {
        this.lootTableSeed = seed;
    }

    public NonNullList<ItemStack> m_213659_() {
        return this.itemStacks;
    }

    public void m_213775_() {
        this.itemStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    }
}

