/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFSounds;

public class SlideBlock
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int WARMUP_TIME = 20;
    private static final EntityDataAccessor<Direction> MOVE_DIRECTION = SynchedEntityData.m_135353_(SlideBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private BlockState myState;
    private int slideTime;

    public SlideBlock(EntityType<? extends SlideBlock> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    public SlideBlock(EntityType<? extends SlideBlock> type, Level world, double x, double y, double z, BlockState state) {
        super(type, world);
        this.myState = state;
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.determineMoveDirection();
    }

    private void determineMoveDirection() {
        Direction[] toCheck;
        Direction[] directionArray;
        BlockPos pos = new BlockPos((Vec3i)this.m_20183_());
        switch ((Direction.Axis)this.myState.m_61143_((Property)RotatedPillarBlock.f_55923_)) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                Direction[] directionArray2 = new Direction[4];
                directionArray2[0] = Direction.DOWN;
                directionArray2[1] = Direction.UP;
                directionArray2[2] = Direction.NORTH;
                directionArray = directionArray2;
                directionArray2[3] = Direction.SOUTH;
                break;
            }
            case Z: {
                Direction[] directionArray3 = new Direction[4];
                directionArray3[0] = Direction.DOWN;
                directionArray3[1] = Direction.UP;
                directionArray3[2] = Direction.WEST;
                directionArray = directionArray3;
                directionArray3[3] = Direction.EAST;
                break;
            }
            case Y: {
                Direction[] directionArray4 = new Direction[4];
                directionArray4[0] = Direction.WEST;
                directionArray4[1] = Direction.EAST;
                directionArray4[2] = Direction.NORTH;
                directionArray = directionArray4;
                directionArray4[3] = Direction.SOUTH;
            }
        }
        for (Direction e : toCheck = directionArray) {
            if (!this.m_9236_().m_46859_(pos.m_121945_(e)) || this.m_9236_().m_46859_(pos.m_121945_(e.m_122424_()))) continue;
            this.f_19804_.m_135381_(MOVE_DIRECTION, (Object)e);
            return;
        }
        for (Direction e : toCheck) {
            if (!this.m_9236_().m_46859_(pos.m_121945_(e))) continue;
            this.f_19804_.m_135381_(MOVE_DIRECTION, (Object)e);
            return;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MOVE_DIRECTION, (Object)Direction.DOWN);
    }

    public boolean m_20161_() {
        return false;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public void m_8119_() {
        if (this.myState == null || this.myState.m_60767_() == Material.f_76296_) {
            this.m_146870_();
        } else {
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            ++this.slideTime;
            if (this.slideTime > 20) {
                double moveAcceleration = 0.04;
                Direction moveDirection = (Direction)this.f_19804_.m_135370_(MOVE_DIRECTION);
                this.m_20256_(this.m_20184_().m_82520_((double)moveDirection.m_122429_() * 0.04, (double)moveDirection.m_122430_() * 0.04, (double)moveDirection.m_122431_() * 0.04));
                this.m_6478_(MoverType.SELF, new Vec3(this.m_20184_().m_7096_(), this.m_20184_().m_7098_(), this.m_20184_().m_7094_()));
            }
            this.m_20184_().m_82542_(0.98, 0.98, 0.98);
            if (!this.m_9236_().m_5776_()) {
                if (this.slideTime % 5 == 0) {
                    this.m_5496_((SoundEvent)TFSounds.SLIDER.get(), 1.0f, 0.9f + this.f_19796_.m_188501_() * 0.4f);
                }
                BlockPos pos = new BlockPos((Vec3i)this.m_20183_());
                if (this.slideTime == 1) {
                    if (this.m_9236_().m_8055_(pos) != this.myState) {
                        this.m_146870_();
                        return;
                    }
                    this.m_9236_().m_7471_(pos, false);
                }
                if (this.slideTime == 60) {
                    this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                    this.f_19804_.m_135381_(MOVE_DIRECTION, (Object)((Direction)this.f_19804_.m_135370_(MOVE_DIRECTION)).m_122424_());
                }
                if (this.f_19863_ || this.f_19862_) {
                    this.m_20256_(this.m_20184_().m_82542_(0.7, 0.7, 0.7));
                    this.m_146870_();
                    if (this.m_9236_().m_45752_(this.myState, pos, CollisionContext.m_82749_())) {
                        this.m_9236_().m_46597_(pos, this.myState);
                    } else {
                        this.m_5552_(new ItemStack((ItemLike)this.myState.m_60734_()), 0.0f);
                    }
                } else if (this.slideTime > 100 && (pos.m_123342_() < this.m_9236_().m_141937_() + 1 || pos.m_123342_() > this.m_9236_().m_151558_()) || this.slideTime > 600) {
                    this.m_5552_(new ItemStack((ItemLike)this.myState.m_60734_()), 0.0f);
                    this.m_146870_();
                }
                this.damageKnockbackEntities(this.m_9236_().m_45933_((Entity)this, this.m_20191_()));
            }
        }
    }

    private void damageKnockbackEntities(List<Entity> entities) {
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.m_6469_(TFDamageTypes.getDamageSource(this.m_9236_(), TFDamageTypes.SLIDER, new EntityType[0]), 5.0f);
            double kx = (this.m_20185_() - entity.m_20185_()) * 2.0;
            double kz = (this.m_20189_() - entity.m_20189_()) * 2.0;
            living.m_147240_(2.0, kx, kz);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6051_() {
        return false;
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        this.slideTime = compound.m_128451_("Time");
        this.f_19804_.m_135381_(MOVE_DIRECTION, (Object)Direction.m_122376_((int)compound.m_128445_("Direction")));
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        compound.m_128405_("Time", this.slideTime);
        compound.m_128344_("Direction", (byte)((Direction)this.f_19804_.m_135370_(MOVE_DIRECTION)).m_122411_());
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(Block.m_49956_((BlockState)this.myState));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.myState = Block.m_49803_((int)additionalData.readInt());
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public BlockState getBlockState() {
        return this.myState;
    }
}

