/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.init.TFBiomes;

@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT})
public class FogHandler {
    private static final float[] spoopColors = new float[3];
    private static float spoopColor = 0.0f;
    private static boolean SKY_CHUNK_LOADED = false;
    private static float SKY_FAR = 0.0f;
    private static float SKY_NEAR = 0.0f;
    private static boolean TERRAIN_CHUNK_LOADED = false;
    private static float TERRAIN_FAR = 0.0f;
    private static float TERRAIN_NEAR = 0.0f;

    @SubscribeEvent
    public static void fogColors(ViewportEvent.ComputeFogColor event) {
        boolean flag = FogHandler.isSpooky(Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_);
        if (flag || spoopColor > 0.0f) {
            float[] realColors = new float[]{event.getRed(), event.getGreen(), event.getBlue()};
            float[] lerpColors = new float[]{0.50980395f, 0.4509804f, 0.5686275f};
            for (int i = 0; i < 3; ++i) {
                boolean inverse;
                float real = realColors[i];
                float spoop = lerpColors[i];
                boolean bl = inverse = real > spoop;
                FogHandler.spoopColors[i] = real == spoop ? spoop : Mth.m_144920_((float)(inverse ? spoop : real), (float)(inverse ? real : spoop), (float)spoopColor);
            }
            float shift = (float)((double)0.01f * event.getPartialTick());
            spoopColor = flag ? (spoopColor += shift) : (spoopColor -= shift);
            spoopColor = Mth.m_14036_((float)spoopColor, (float)0.0f, (float)1.0f);
            event.setRed(spoopColors[0]);
            event.setGreen(spoopColors[1]);
            event.setBlue(spoopColors[2]);
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        Entity entity;
        if (event.getType().equals((Object)FogType.NONE) && (entity = Minecraft.m_91087_().f_91075_) instanceof LocalPlayer) {
            ClientLevel clientLevel;
            LocalPlayer player = (LocalPlayer)entity;
            entity = player.f_19853_;
            if (entity instanceof ClientLevel && (clientLevel = (ClientLevel)entity).m_104583_() instanceof TwilightForestRenderInfo) {
                if (event.getMode().equals((Object)FogRenderer.FogMode.FOG_SKY)) {
                    if (SKY_CHUNK_LOADED) {
                        event.setCanceled(true);
                        boolean spooky = FogHandler.isSpooky(clientLevel, player);
                        float far = spooky ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                        float near = spooky ? 0.0f : event.getNearPlaneDistance();
                        SKY_FAR = Mth.m_14179_((float)0.003f, (float)SKY_FAR, (float)far);
                        SKY_NEAR = Mth.m_14179_((float)(0.003f * (SKY_NEAR < near ? 0.5f : 2.0f)), (float)SKY_NEAR, (float)near);
                        event.setFarPlaneDistance(SKY_FAR);
                        event.setNearPlaneDistance(SKY_NEAR);
                    } else if (clientLevel.m_46749_(player.m_20183_())) {
                        SKY_CHUNK_LOADED = true;
                        SKY_FAR = FogHandler.isSpooky(clientLevel, player) ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                        SKY_NEAR = FogHandler.isSpooky(clientLevel, player) ? 0.0f : event.getNearPlaneDistance();
                    }
                } else if (TERRAIN_CHUNK_LOADED) {
                    event.setCanceled(true);
                    boolean spooky = FogHandler.isSpooky(clientLevel, player);
                    float far = spooky ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                    float near = spooky ? far * 0.75f : event.getNearPlaneDistance();
                    TERRAIN_FAR = Mth.m_14179_((float)0.003f, (float)TERRAIN_FAR, (float)far);
                    TERRAIN_NEAR = Mth.m_14179_((float)(0.003f * (TERRAIN_NEAR < near ? 0.5f : 2.0f)), (float)TERRAIN_NEAR, (float)near);
                    event.setFarPlaneDistance(TERRAIN_FAR);
                    event.setNearPlaneDistance(TERRAIN_NEAR);
                } else if (SKY_CHUNK_LOADED || clientLevel.m_46749_(player.m_20183_())) {
                    TERRAIN_CHUNK_LOADED = true;
                    TERRAIN_FAR = FogHandler.isSpooky(clientLevel, player) ? event.getFarPlaneDistance() * 0.5f : event.getFarPlaneDistance();
                    TERRAIN_NEAR = FogHandler.isSpooky(clientLevel, player) ? TERRAIN_FAR * 0.75f : event.getNearPlaneDistance();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onUnload(LevelEvent.Unload event) {
        SKY_CHUNK_LOADED = false;
        TERRAIN_CHUNK_LOADED = false;
    }

    private static boolean isSpooky(@Nullable ClientLevel level, @Nullable LocalPlayer player) {
        return level != null && player != null && level.m_204166_(player.m_20183_()).m_203565_(TFBiomes.SPOOKY_FOREST);
    }
}

