/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import twilightforest.block.GhastTrapBlock;
import twilightforest.entity.boss.UrGhast;
import twilightforest.entity.monster.CarminiteGhastguard;
import twilightforest.entity.monster.CarminiteGhastling;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class GhastTrapBlockEntity
extends BlockEntity {
    private int counter = 0;
    private final List<CarminiteGhastling> dyingGhasts = new ArrayList<CarminiteGhastling>();
    private final RandomSource rand = RandomSource.m_216327_();

    public GhastTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.GHAST_TRAP.get(), pos, state);
    }

    private void tickInactive(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        AABB aabb = new AABB(pos).m_82377_(10.0, 16.0, 10.0);
        List nearbyGhasts = level.m_45976_(CarminiteGhastling.class, aabb);
        for (CarminiteGhastling ghast : nearbyGhasts) {
            if (ghast.f_20919_ <= 0) continue;
            te.makeParticlesTo((Entity)ghast);
            if (te.dyingGhasts.contains(ghast)) continue;
            te.dyingGhasts.add(ghast);
        }
        int chargeLevel = Math.min(3, te.dyingGhasts.size());
        ++te.counter;
        if (level.m_5776_()) {
            if (te.counter % 20 == 0 && nearbyGhasts.size() > 0) {
                CarminiteGhastling highlight = (CarminiteGhastling)nearbyGhasts.get(te.rand.m_188503_(nearbyGhasts.size()));
                te.makeParticlesTo((Entity)highlight);
            }
            if (chargeLevel >= 1 && te.counter % 10 == 0) {
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (chargeLevel >= 2) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.1 + (double)te.rand.m_188501_() * 0.8, (double)pos.m_123342_() + 1.05, (double)pos.m_123343_() + 0.1 + (double)te.rand.m_188501_() * 0.8, (double)(te.rand.m_188501_() - te.rand.m_188501_()) * 0.05, 0.0, (double)(te.rand.m_188501_() - te.rand.m_188501_()) * 0.05);
                if (te.counter % 10 == 0) {
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.2f, 0.8f, false);
                }
            }
            if (chargeLevel >= 3) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + 0.1 + (double)te.rand.m_188501_() * 0.8, (double)pos.m_123342_() + 1.05, (double)pos.m_123343_() + 0.1 + (double)te.rand.m_188501_() * 0.8, (double)(te.rand.m_188501_() - te.rand.m_188501_()) * 0.05, 0.05, (double)(te.rand.m_188501_() - te.rand.m_188501_()) * 0.05);
                ((GhastTrapBlock)((Object)TFBlocks.GHAST_TRAP.get())).sparkle(level, pos);
                if (te.counter % 5 == 0) {
                    level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_AMBIENT.get(), SoundSource.BLOCKS, 1.5f, 2.0f, false);
                }
            }
        }
    }

    private void makeParticlesTo(Entity highlight) {
        double sx = (double)this.m_58899_().m_123341_() + 0.5;
        double sy = (double)this.m_58899_().m_123342_() + 1.0;
        double sz = (double)this.m_58899_().m_123343_() + 0.5;
        double dx = sx - highlight.m_20185_();
        double dy = sy - highlight.m_20186_() - (double)highlight.m_20192_();
        double dz = sz - highlight.m_20189_();
        for (int i = 0; i < 5; ++i) {
            this.m_58904_().m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), sx, sy, sz, -dx, -dy, -dz);
        }
    }

    public boolean isCharged() {
        return this.dyingGhasts.size() >= 3;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        if (((Boolean)state.m_61143_((Property)GhastTrapBlock.ACTIVE)).booleanValue()) {
            te.tickActive(level, pos, state, te);
        } else {
            te.tickInactive(level, pos, state, te);
        }
    }

    public boolean m_7531_(int event, int payload) {
        if (event == 0) {
            this.counter = 0;
            this.dyingGhasts.clear();
            return true;
        }
        if (event == 1) {
            this.counter = 0;
            return true;
        }
        return false;
    }

    private void tickActive(Level level, BlockPos pos, BlockState state, GhastTrapBlockEntity te) {
        ++te.counter;
        if (level.m_5776_()) {
            if (te.counter > 100 && te.counter % 4 == 0) {
                level.m_7106_((ParticleOptions)TFParticleType.HUGE_SMOKE.get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.95, (double)pos.m_123343_() + 0.5, Math.cos((double)te.counter / 10.0) * 0.05, 0.25, Math.sin((double)te.counter / 10.0) * 0.05);
            } else if (te.counter < 100) {
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 1.0;
                double z = (double)pos.m_123343_() + 0.5;
                double dx = Math.cos((double)te.counter / 10.0) * 2.5;
                double dy = 20.0;
                double dz = Math.sin((double)te.counter / 10.0) * 2.5;
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy, dz);
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy, -dz);
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx, dy / 2.0, dz);
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx, dy / 2.0, -dz);
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, dx / 2.0, dy / 4.0, dz / 2.0);
                level.m_7106_((ParticleOptions)TFParticleType.GHAST_TRAP.get(), x, y, z, -dx / 2.0, dy / 4.0, -dz / 2.0);
            }
            if (te.counter < 30) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_WARMUP.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            } else if (te.counter < 80) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_ON.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            } else {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TFSounds.GHAST_TRAP_SPINDOWN.get(), SoundSource.BLOCKS, 1.0f, 4.0f, false);
            }
        } else {
            AABB aabb = new AABB(pos.m_6630_(16), pos.m_6630_(16).m_7918_(1, 1, 1)).m_82377_(6.0, 16.0, 6.0);
            List nearbyGhasts = level.m_45976_(Ghast.class, aabb);
            for (Ghast ghast : nearbyGhasts) {
                if (ghast instanceof UrGhast) {
                    UrGhast urghast = (UrGhast)ghast;
                    urghast.setInTantrum(false);
                    ghast.f_19794_ = true;
                    mx = (ghast.m_20185_() - (double)pos.m_123341_() - 0.5) * -0.1;
                    my = (ghast.m_20186_() - (double)pos.m_123342_() - 2.5) * -0.1;
                    mz = (ghast.m_20189_() - (double)pos.m_123343_() - 0.5) * -0.1;
                    ghast.m_20334_(mx, my, mz);
                    if (te.rand.m_188503_(10) == 0) {
                        ghast.m_6469_(level.m_269111_().m_269264_(), 7.0f);
                        urghast.resetDamageUntilNextPhase();
                    }
                } else {
                    mx = (ghast.m_20185_() - (double)pos.m_123341_() - 0.5) * -0.1;
                    my = (ghast.m_20186_() - (double)pos.m_123342_() - 1.5) * -0.1;
                    mz = (ghast.m_20189_() - (double)pos.m_123343_() - 0.5) * -0.1;
                    ghast.m_20334_(mx, my, mz);
                    if (te.rand.m_188503_(10) == 0) {
                        ghast.m_6469_(level.m_269111_().m_269264_(), 10.0f);
                    }
                }
                if (!(ghast instanceof CarminiteGhastguard)) continue;
                ((CarminiteGhastguard)ghast).setInTrap();
            }
            if (te.counter >= 120) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)GhastTrapBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                level.m_7696_(pos, state.m_60734_(), 1, 0);
            }
        }
    }
}

