/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.CinderFurnaceBlock;
import twilightforest.init.TFBlocks;

public class CinderFurnaceBlockEntity
extends FurnaceBlockEntity {
    private static final int SMELT_LOG_FACTOR = 10;

    public CinderFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CinderFurnaceBlockEntity te) {
        boolean flag = te.isBurning();
        boolean flag1 = false;
        if (te.isBurning()) {
            --te.f_58316_;
        }
        if (!level.m_5776_()) {
            ItemStack itemstack = (ItemStack)te.f_58310_.get(1);
            if (te.isBurning() || !itemstack.m_41619_() && !((ItemStack)te.f_58310_.get(0)).m_41619_()) {
                Recipe irecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)te, level).orElse(null);
                if (!te.isBurning() && te.canBurn(irecipe)) {
                    te.f_58317_ = te.f_58316_ = te.m_7743_(itemstack);
                    if (te.isBurning()) {
                        flag1 = true;
                        if (!itemstack.m_41619_()) {
                            Item item = itemstack.m_41720_();
                            itemstack.m_41774_(1);
                            if (itemstack.m_41619_()) {
                                ItemStack item1 = item.getCraftingRemainingItem(itemstack);
                                te.f_58310_.set(1, (Object)item1);
                            }
                        }
                    }
                }
                if (te.isBurning() && te.canBurn(irecipe)) {
                    te.f_58318_ += te.getCurrentSpeedMultiplier();
                    if (te.f_58318_ >= te.f_58319_) {
                        te.f_58318_ = 0;
                        te.f_58319_ = te.getRecipeBurnTime();
                        te.smeltItem(irecipe);
                        flag1 = true;
                    }
                } else {
                    te.f_58318_ = 0;
                }
            } else if (!te.isBurning() && te.f_58318_ > 0) {
                te.f_58318_ = Mth.m_14045_((int)(te.f_58318_ - 2), (int)0, (int)te.f_58319_);
            }
            if (flag != te.isBurning()) {
                flag1 = true;
                level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)CinderFurnaceBlock.LIT, (Comparable)Boolean.valueOf(te.isBurning())), 3);
            }
            if (te.isBurning() && te.f_58316_ % 5 == 0) {
                te.cinderizeNearbyLog();
            }
        }
        if (flag1) {
            te.m_6596_();
        }
    }

    private boolean isBurning() {
        return this.f_58316_ > 0;
    }

    protected int getRecipeBurnTime() {
        return this.m_58904_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)this, this.m_58904_()).map(AbstractCookingRecipe::m_43753_).orElse(200);
    }

    private void cinderizeNearbyLog() {
        BlockState nearbyBlock;
        RandomSource rand = this.m_58904_().m_213780_();
        int dx = rand.m_188503_(2) - rand.m_188503_(2);
        int dy = rand.m_188503_(2) - rand.m_188503_(2);
        int dz = rand.m_188503_(2) - rand.m_188503_(2);
        BlockPos pos = this.m_58899_().m_7918_(dx, dy, dz);
        if (this.m_58904_().m_46805_(pos) && !(nearbyBlock = this.m_58904_().m_8055_(pos)).m_60713_((Block)TFBlocks.CINDER_LOG.get()) && nearbyBlock.m_204336_(BlockTags.f_13106_)) {
            this.m_58904_().m_7731_(pos, this.getCinderLog(dx, dy, dz), 2);
            this.m_58904_().m_46796_(2004, pos, 0);
            this.m_58904_().m_46796_(2004, pos, 0);
            this.m_58904_().m_5594_(null, pos, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private BlockState getCinderLog(int dx, int dy, int dz) {
        @Nullable Object direction = dz == 0 && dx != 0 ? (dy == 0 ? Direction.Axis.X : Direction.Axis.Z) : (dx == 0 && dz != 0 ? (dy == 0 ? Direction.Axis.Z : Direction.Axis.X) : (dx == 0 ? Direction.Axis.Y : (dy == 0 ? Direction.Axis.Y : null)));
        return direction != null ? (BlockState)((RotatedPillarBlock)TFBlocks.CINDER_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)direction) : ((Block)TFBlocks.CINDER_WOOD.get()).m_49966_();
    }

    private int getCurrentSpeedMultiplier() {
        return this.getCurrentMultiplier(2);
    }

    private int getCurrentMultiplier(int factor) {
        int logs = this.countNearbyLogs();
        if (logs < factor) {
            return 1;
        }
        return logs / factor + (this.m_58904_().m_213780_().m_188503_(factor) >= logs % factor ? 0 : 1);
    }

    private int countNearbyLogs() {
        int count = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos = this.m_58899_().m_7918_(dx, dy, dz);
                    if (!this.m_58904_().m_46805_(pos) || this.m_58904_().m_8055_(pos).m_60734_() != TFBlocks.CINDER_LOG.get()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    protected boolean canBurn(Recipe<?> recipe) {
        if (((ItemStack)this.f_58310_.get(0)).m_41619_()) {
            return false;
        }
        ItemStack itemstack = recipe.m_8043_(this.m_58904_().m_9598_());
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.f_58310_.get(2);
        if (itemstack1.m_41619_()) {
            return true;
        }
        if (!itemstack1.m_41656_(itemstack)) {
            return false;
        }
        int result = itemstack1.m_41613_() + this.getMaxOutputStacks((ItemStack)this.f_58310_.get(0), itemstack);
        return result <= this.m_6893_() && result <= itemstack1.m_41741_();
    }

    public int getMaxOutputStacks(ItemStack input, ItemStack output) {
        if (this.canMultiply(input, output)) {
            return output.m_41613_() * this.getCurrentMaxSmeltMultiplier();
        }
        return output.m_41613_();
    }

    public void smeltItem(Recipe<?> recipe) {
        if (this.canBurn(recipe)) {
            ItemStack itemstack = (ItemStack)this.f_58310_.get(0);
            ItemStack itemstack1 = recipe.m_8043_(this.m_58904_().m_9598_());
            itemstack1.m_41764_(itemstack1.m_41613_() * this.getCurrentSmeltMultiplier());
            ItemStack itemstack2 = (ItemStack)this.f_58310_.get(2);
            if (itemstack2.m_41619_()) {
                this.f_58310_.set(2, (Object)itemstack1.m_41777_());
            } else if (itemstack2.m_41720_() == itemstack1.m_41720_()) {
                itemstack2.m_41769_(itemstack1.m_41613_());
            }
            if (itemstack.m_41720_() == Blocks.f_50057_.m_5456_() && !((ItemStack)this.f_58310_.get(1)).m_41619_() && ((ItemStack)this.f_58310_.get(1)).m_41720_() == Items.f_42446_) {
                this.f_58310_.set(1, (Object)new ItemStack((ItemLike)Items.f_42447_));
            }
            itemstack.m_41774_(1);
        }
    }

    private boolean canMultiply(ItemStack input, ItemStack output) {
        return input.m_204117_(ItemTags.f_13182_) || input.m_204117_(Tags.Items.ORES);
    }

    private int getCurrentSmeltMultiplier() {
        return this.getCurrentMultiplier(10);
    }

    private int getCurrentMaxSmeltMultiplier() {
        return (int)Math.ceil((float)this.countNearbyLogs() / 10.0f);
    }
}

