/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.SlideBlock;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFEntities;

public class SliderBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty DELAY = IntegerProperty.m_61631_((String)"delay", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final int TICK_TIME = 80;
    private static final int OFFSET_TIME = 20;
    private static final int PLAYER_RANGE = 32;
    private static final float BLOCK_DAMAGE = 5.0f;
    private static final VoxelShape Y_BB = Shapes.m_83064_((AABB)new AABB(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875));
    private static final VoxelShape Z_BB = Shapes.m_83064_((AABB)new AABB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0));
    private static final VoxelShape X_BB = Shapes.m_83064_((AABB)new AABB(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875));

    public SliderBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76408_).m_60913_(2.0f, 10.0f).m_60977_().m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)DELAY, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return super.m_7417_(state, facing, facingState, accessor, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DELAY, WATERLOGGED});
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Direction.Axis.X -> X_BB;
            case Direction.Axis.Z -> Z_BB;
            default -> Y_BB;
        };
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.m_5776_() && this.isConnectedInRange((Level)level, pos)) {
            SlideBlock slideBlock = new SlideBlock((EntityType<? extends SlideBlock>)((EntityType)TFEntities.SLIDER.get()), (Level)level, (double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, state);
            level.m_7967_((Entity)slideBlock);
        }
        this.scheduleBlockUpdate((Level)level, pos);
    }

    public boolean isConnectedInRange(Level level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)level.m_8055_(pos).m_61143_((Property)f_55923_);
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.Y -> {
                if (this.anyPlayerInRange(level, pos) || this.isConnectedInRangeRecursive(level, pos, Direction.UP) || this.isConnectedInRangeRecursive(level, pos, Direction.DOWN)) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.X -> {
                if (this.anyPlayerInRange(level, pos) || this.isConnectedInRangeRecursive(level, pos, Direction.WEST) || this.isConnectedInRangeRecursive(level, pos, Direction.EAST)) {
                    yield true;
                }
                yield false;
            }
            case Direction.Axis.Z -> this.anyPlayerInRange(level, pos) || this.isConnectedInRangeRecursive(level, pos, Direction.NORTH) || this.isConnectedInRangeRecursive(level, pos, Direction.SOUTH);
        };
    }

    private boolean isConnectedInRangeRecursive(Level level, BlockPos pos, Direction dir) {
        BlockPos dPos = pos.m_121945_(dir);
        if (level.m_8055_(pos) == level.m_8055_(dPos)) {
            return this.anyPlayerInRange(level, dPos) || this.isConnectedInRangeRecursive(level, dPos, dir);
        }
        return false;
    }

    private boolean anyPlayerInRange(Level level, BlockPos pos) {
        return level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 32.0, false) != null;
    }

    public void scheduleBlockUpdate(Level level, BlockPos pos) {
        int offset = (Integer)level.m_8055_(pos).m_61143_((Property)DELAY);
        int update = 80 - (int)(level.m_46467_() - (long)(offset * 20)) % 80;
        level.m_186460_(pos, (Block)this, update);
    }

    @Deprecated
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.scheduleBlockUpdate(level, pos);
    }

    @Deprecated
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.m_6469_(TFDamageTypes.getDamageSource(level, TFDamageTypes.SLIDER, new EntityType[0]), 5.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double kx = ((double)pos.m_123341_() + 0.5 - entity.m_20185_()) * 2.0;
            double kz = ((double)pos.m_123343_() + 0.5 - entity.m_20189_()) * 2.0;
            living.m_147240_(2.0, kx, kz);
        }
    }
}

