/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ForceFieldBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    protected static final VoxelShape BASE_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0);
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    protected static final VoxelShape DOWN_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)7.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_EAST_SHAPE = Block.m_49796_((double)9.0, (double)0.0, (double)7.0, (double)16.0, (double)7.0, (double)9.0);
    protected static final VoxelShape DOWN_NORTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0);
    protected static final VoxelShape DOWN_SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)7.0, (double)16.0);
    protected static final VoxelShape UP_WEST_SHAPE = Block.m_49796_((double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_EAST_SHAPE = Block.m_49796_((double)9.0, (double)9.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape UP_NORTH_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)0.0, (double)9.0, (double)16.0, (double)7.0);
    protected static final VoxelShape UP_SOUTH_SHAPE = Block.m_49796_((double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)7.0);
    protected static final VoxelShape NORTH_EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)7.0);
    protected static final VoxelShape SOUTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)16.0);
    protected static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)9.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0, (double)16.0);

    public ForceFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getVoxelShape(state);
    }

    private VoxelShape getVoxelShape(BlockState state) {
        boolean z;
        VoxelShape shape = BASE_SHAPE;
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean north = (Boolean)state.m_61143_((Property)NORTH);
        boolean south = (Boolean)state.m_61143_((Property)SOUTH);
        boolean west = (Boolean)state.m_61143_((Property)WEST);
        boolean east = (Boolean)state.m_61143_((Property)EAST);
        boolean x = west && east;
        boolean y = down && up;
        boolean bl = z = north && south;
        if (down) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SHAPE);
            if (north && (!x || axis != Direction.Axis.X)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_NORTH_SHAPE);
            }
            if (south && (!x || axis != Direction.Axis.X)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_SOUTH_SHAPE);
            }
            if (west && (!z || axis != Direction.Axis.Z)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_WEST_SHAPE);
            }
            if (east && (!z || axis != Direction.Axis.Z)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)DOWN_EAST_SHAPE);
            }
        }
        if (up) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SHAPE);
            if (north && (!x || axis != Direction.Axis.X)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_NORTH_SHAPE);
            }
            if (south && (!x || axis != Direction.Axis.X)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_SOUTH_SHAPE);
            }
            if (west && (!z || axis != Direction.Axis.Z)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_WEST_SHAPE);
            }
            if (east && (!z || axis != Direction.Axis.Z)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)UP_EAST_SHAPE);
            }
        }
        if (north) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_SHAPE);
            if (west && (!y || axis != Direction.Axis.Y)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_WEST_SHAPE);
            }
            if (east && (!y || axis != Direction.Axis.Y)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_EAST_SHAPE);
            }
        }
        if (south) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_SHAPE);
            if (west && (!y || axis != Direction.Axis.Y)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_WEST_SHAPE);
            }
            if (east && (!y || axis != Direction.Axis.Y)) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_EAST_SHAPE);
            }
        }
        if (west) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_SHAPE);
        }
        if (east) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_SHAPE);
        }
        return shape;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        BooleanProperty opposite;
        if (adjacentState.m_60713_((Block)this) && ((Boolean)adjacentState.m_61143_((Property)(opposite = (BooleanProperty)PipeBlock.f_55154_.get(direction.m_122424_())))).booleanValue()) {
            BooleanProperty property = (BooleanProperty)PipeBlock.f_55154_.get(direction);
            if (ForceFieldBlock.countSides((BlockState)((BlockState)state.m_61124_((Property)opposite, (Comparable)Boolean.valueOf(false))).m_61124_((Property)property, (Comparable)Boolean.valueOf(false))) > ForceFieldBlock.countSides((BlockState)((BlockState)adjacentState.m_61124_((Property)opposite, (Comparable)Boolean.valueOf(false))).m_61124_((Property)property, (Comparable)Boolean.valueOf(false))) && state.m_61143_(AXIS) == direction.m_122434_()) {
                return false;
            }
            VoxelShape a = this.getVoxelShape(state).m_83263_(direction);
            VoxelShape b = this.getVoxelShape(adjacentState).m_83263_(direction.m_122424_());
            return a.m_83299_().stream().anyMatch(aabb -> b.m_83299_().stream().anyMatch(arg_0 -> ((AABB)aabb).equals(arg_0)));
        }
        return false;
    }

    private static int countSides(BlockState state) {
        int count = 0;
        for (Direction direction : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public float m_7749_(BlockState state, BlockGetter getter, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public boolean canConnectTo(BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState state = getter.m_8055_(pos.m_121945_(direction));
        boolean solidSide = state.m_60783_(getter, pos.m_121945_(direction), direction.m_122424_());
        Block block = state.m_60734_();
        int betterConnections = 0;
        if (!state.m_60713_((Block)this)) {
            for (Direction face : Direction.values()) {
                if (!getter.m_8055_(pos.m_121945_(face)).m_60713_((Block)this)) continue;
                ++betterConnections;
            }
            if (betterConnections > 3) {
                return false;
            }
        }
        return !ForceFieldBlock.m_152463_((BlockState)state) && solidSide || block instanceof ForceFieldBlock || block instanceof IronBarsBlock || state.m_204336_(BlockTags.f_13032_);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        Direction clicked = context.m_43719_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_())).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(clicked != Direction.DOWN ? this.canConnectTo((BlockGetter)level, pos, Direction.DOWN) : !context.m_7078_()))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(clicked != Direction.UP ? this.canConnectTo((BlockGetter)level, pos, Direction.UP) : !context.m_7078_()))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(clicked != Direction.NORTH ? this.canConnectTo((BlockGetter)level, pos, Direction.NORTH) : !context.m_7078_()))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(clicked != Direction.EAST ? this.canConnectTo((BlockGetter)level, pos, Direction.EAST) : !context.m_7078_()))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(clicked != Direction.SOUTH ? this.canConnectTo((BlockGetter)level, pos, Direction.SOUTH) : !context.m_7078_()))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(clicked != Direction.WEST ? this.canConnectTo((BlockGetter)level, pos, Direction.WEST) : !context.m_7078_()));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor accessor, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return (BlockState)state.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)accessor, pos, direction)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS, NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }
}

