/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.block.entity.CarminiteBuilderBlockEntity;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

public class BuilderBlock
extends BaseEntityBlock {
    public static final EnumProperty<TowerDeviceVariant> STATE = EnumProperty.m_61587_((String)"state", TowerDeviceVariant.class);

    public BuilderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    @Deprecated
    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.m_5776_() && state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_INACTIVE && level.m_46753_(pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            level.m_5594_(null, pos, (SoundEvent)TFSounds.BUILDER_ON.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.m_61143_(STATE));
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE && level.m_46753_(pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            level.m_5594_(null, pos, (SoundEvent)TFSounds.BUILDER_ON.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_186460_(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && !level.m_46753_(pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
            level.m_5594_(null, pos, (SoundEvent)TFSounds.BUILDER_OFF.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_186460_(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_TIMEOUT && !level.m_46753_(pos)) {
            level.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.m_61143_(STATE));
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && level.m_46753_(pos)) {
            this.letsBuild((Level)level, pos);
        }
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE || variant == TowerDeviceVariant.BUILDER_TIMEOUT) {
            ((CarminiteBuilderBlockEntity)Objects.requireNonNull(level.m_7702_(pos))).resetStats();
            for (Direction e : Direction.values()) {
                BuilderBlock.activateBuiltBlocks((Level)level, pos.m_121945_(e));
            }
        }
    }

    private void letsBuild(Level level, BlockPos pos) {
        CarminiteBuilderBlockEntity tileEntity = (CarminiteBuilderBlockEntity)level.m_7702_(pos);
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_ACTIVE) {
            this.sparkle(level, pos);
        }
    }

    public void sparkle(Level level, BlockPos pos) {
        RandomSource random = level.m_213780_();
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.m_123341_() + random.m_188501_();
            double d2 = (float)pos.m_123342_() + random.m_188501_();
            double d3 = (float)pos.m_123343_() + random.m_188501_();
            if (i == 0 && !level.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() + d0 + 1.0;
            }
            if (i == 1 && !level.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)level, pos)) {
                d2 = (double)pos.m_123342_() - d0;
            }
            if (i == 2 && !level.m_8055_(pos.m_122019_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() + d0 + 1.0;
            }
            if (i == 3 && !level.m_8055_(pos.m_122012_()).m_60804_((BlockGetter)level, pos)) {
                d3 = (double)pos.m_123343_() - d0;
            }
            if (i == 4 && !level.m_8055_(pos.m_122029_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() + d0 + 1.0;
            }
            if (i == 5 && !level.m_8055_(pos.m_122024_()).m_60804_((BlockGetter)level, pos)) {
                d1 = (double)pos.m_123341_() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.m_123341_() || d1 > (double)(pos.m_123341_() + 1) || d2 < 0.0 || d2 > (double)(pos.m_123342_() + 1) || d3 < (double)pos.m_123343_()) && !(d3 > (double)(pos.m_123343_() + 1))) continue;
            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public static void activateBuiltBlocks(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == TFBlocks.BUILT_BLOCK.get() && !((Boolean)state.m_61143_((Property)TranslucentBuiltBlock.ACTIVE)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            level.m_5594_(null, pos, (SoundEvent)TFSounds.BUILDER_REPLACE.get(), SoundSource.BLOCKS, 0.3f, 0.6f);
            level.m_186460_(pos, state.m_60734_(), 10);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CarminiteBuilderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_ACTIVE ? BuilderBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.TOWER_BUILDER.get()), CarminiteBuilderBlockEntity::tick) : null;
    }
}

