/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import twilightforest.FoliageColorHandler;
import twilightforest.TFMagicMapData;
import twilightforest.client.TFClientSetup;
import twilightforest.entity.TFPart;
import twilightforest.events.ToolEvents;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDimensionSettings;
import twilightforest.init.TFItems;
import twilightforest.item.GiantItem;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateTFMultipartPacket;
import twilightforest.world.components.structures.util.CustomStructureData;
import twilightforest.world.registration.TFGenerationSettings;

public class ASMHooks {
    public static long seed(long seed) {
        TFDimensionSettings.seed = seed;
        return seed;
    }

    public static void mapRenderContext(PoseStack stack, MultiBufferSource buffer, int light) {
        TFMagicMapData.TFMapDecoration.RenderContext.stack = stack;
        TFMagicMapData.TFMapDecoration.RenderContext.buffer = buffer;
        TFMagicMapData.TFMapDecoration.RenderContext.light = light;
    }

    private static boolean isOurMap(ItemStack stack) {
        return stack.m_150930_((Item)TFItems.FILLED_MAGIC_MAP.get()) || stack.m_150930_((Item)TFItems.FILLED_MAZE_MAP.get()) || stack.m_150930_((Item)TFItems.FILLED_ORE_MAP.get());
    }

    public static boolean shouldMapRender(boolean o, ItemStack stack) {
        return o || ASMHooks.isOurMap(stack);
    }

    @Nullable
    public static MapItemSavedData renderMapData(@Nullable MapItemSavedData o, ItemStack stack, @Nullable Level level) {
        return ASMHooks.isOurMap(stack) && level != null ? MapItem.m_42853_((ItemStack)stack, (Level)level) : o;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Music music(Music music) {
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null && (music == Musics.f_11646_ || music == Musics.f_11650_) && TFGenerationSettings.isTwilightWorldOnClient((Level)Minecraft.m_91087_().f_91073_)) {
            return ((Biome)Minecraft.m_91087_().f_91073_.m_7062_().m_204216_(Minecraft.m_91087_().f_91074_.m_20183_()).m_203334_()).m_47566_().orElse(Musics.f_11651_);
        }
        return music;
    }

    public static Entity updateMultiparts(Entity entity) {
        if (entity.isMultipartEntity()) {
            TFPacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new UpdateTFMultipartPacket(entity));
        }
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static EntityRenderer<?> getMultipartRenderer(@Nullable EntityRenderer<?> renderer, Entity entity) {
        if (entity instanceof TFPart) {
            return TFClientSetup.BakedMultiPartRenderers.lookup(((TFPart)entity).renderer());
        }
        return renderer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EntityRendererProvider.Context bakeMultipartRenders(EntityRendererProvider.Context context) {
        TFClientSetup.BakedMultiPartRenderers.bakeMultiPartRenderers(context);
        return context;
    }

    public static Iterable<Entity> renderMutiparts(Iterable<Entity> iter) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        iter.forEach(entity -> {
            list.add((Entity)entity);
            if (entity.isMultipartEntity() && entity.getParts() != null) {
                for (PartEntity part : entity.getParts()) {
                    if (!(part instanceof TFPart)) continue;
                    list.add((Entity)part);
                }
            }
        });
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int foliage(int o, Biome biome, double x, double z) {
        return FoliageColorHandler.get(o, biome, x, z);
    }

    public static StructureStart conquered(StructureStart start, PiecesContainer piecesContainer, CompoundTag nbt) {
        Structure structure = start.m_226861_();
        if (structure instanceof CustomStructureData) {
            CustomStructureData s = (CustomStructureData)structure;
            return s.forDeserialization(start.m_226861_(), start.m_163625_(), start.m_73608_(), piecesContainer, nbt);
        }
        return start;
    }

    public static boolean mountFix(boolean o, boolean wantsToStopRiding, boolean isPassenger) {
        if (wantsToStopRiding && isPassenger) {
            return false;
        }
        return o;
    }

    public static Component book(Component component, CompoundTag tag) {
        if (tag.m_128441_("twilightforest:book")) {
            return Component.m_237115_((String)component.getString());
        }
        return component;
    }

    public static BlockHitResult reach(BlockHitResult o, Level level, Player player, ClipContext.Fluid fluidMode) {
        BlockHitResult hitResult;
        InteractionHand hand = ToolEvents.INTERACTION_HAND;
        if (hand != null && (hitResult = ASMHooks.interactionTooFar(level, player, hand, fluidMode)) != null) {
            return hitResult;
        }
        return o;
    }

    @Nullable
    private static BlockHitResult interactionTooFar(Level level, Player player, InteractionHand hand, ClipContext.Fluid fluidMode) {
        ItemStack heldStack = player.m_21120_(hand);
        if (ToolEvents.hasGiantItemInOneHand(player) && !(heldStack.m_41720_() instanceof GiantItem) && hand == InteractionHand.OFF_HAND) {
            AttributeModifier giantModifier;
            UUID uuidForOppositeHand = GiantItem.GIANT_REACH_MODIFIER;
            AttributeInstance reachDistance = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get());
            if (reachDistance != null && (giantModifier = reachDistance.m_22111_(uuidForOppositeHand)) != null) {
                reachDistance.m_22130_(giantModifier);
                double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get());
                double trueReach = reach == 0.0 ? 0.0 : reach + (player.m_7500_() ? 0.5 : 0.0);
                BlockHitResult result = ASMHooks.getPlayerPOVHitResultForReach(level, player, trueReach, fluidMode);
                reachDistance.m_22118_(giantModifier);
                return result;
            }
        }
        return null;
    }

    private static BlockHitResult getPlayerPOVHitResultForReach(Level level, Player player, double reach, ClipContext.Fluid fluidClip) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, fluidClip, (Entity)player));
    }

    public static int shroom(int o, LevelReader level, BlockPos pos) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0 || !level.m_8055_(pos.m_7918_(x, -1, z)).m_60713_((Block)TFBlocks.TWILIGHT_PORTAL.get())) continue;
                return 0;
            }
        }
        return o;
    }
}

