/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.regsitry.fluid;

import earth.terrarium.botarium.common.registry.fluid.FluidProperties;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class BotariumFluidType
extends FluidType {
    private final FluidProperties fluidProperties;

    private BotariumFluidType(FluidProperties fluidProperties, FluidType.Properties properties) {
        super(properties);
        this.fluidProperties = fluidProperties;
    }

    public static BotariumFluidType of(FluidProperties fluidProperties) {
        FluidType.Properties properties = FluidType.Properties.create();
        properties.descriptionId(Util.m_137492_((String)"fluid_type", (ResourceLocation)fluidProperties.id()));
        properties.adjacentPathType(fluidProperties.adjacentPathType());
        properties.canConvertToSource(fluidProperties.canConvertToSource());
        properties.canDrown(fluidProperties.canDrown());
        properties.canExtinguish(fluidProperties.canExtinguish());
        properties.canHydrate(fluidProperties.canHydrate());
        properties.canPushEntity(fluidProperties.canPushEntity());
        properties.canSwim(fluidProperties.canSwim());
        properties.density(fluidProperties.density());
        properties.fallDistanceModifier(fluidProperties.fallDistanceModifier());
        properties.lightLevel(fluidProperties.lightLevel());
        properties.motionScale(fluidProperties.motionScale());
        properties.pathType(fluidProperties.pathType());
        properties.rarity(fluidProperties.rarity());
        properties.temperature(fluidProperties.temperature());
        properties.viscosity(fluidProperties.viscosity());
        fluidProperties.sounds().getSounds().forEach((name, sound) -> properties.sound(SoundAction.get((String)name), sound));
        return new BotariumFluidType(fluidProperties, properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        final BotariumFluidType type = this;
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return type.fluidProperties.still();
            }

            public ResourceLocation getFlowingTexture() {
                return type.fluidProperties.flowing();
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return type.fluidProperties.overlay();
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return type.fluidProperties.screenOverlay();
            }

            public int getTintColor() {
                return type.fluidProperties.tintColor();
            }
        });
    }
}

