/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import earth.terrarium.botarium.util.Updatable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeItemFluidContainer<T extends ItemFluidContainer & Updatable<ItemStack>>(T container, ItemStack itemStack) implements IFluidHandlerItem,
ICapabilityProvider
{
    @NotNull
    public ItemStack getContainer() {
        return this.container.getContainerItem();
    }

    public int getTanks() {
        return this.container.getSize();
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return new ForgeFluidHolder(this.container.getFluids().get(i)).getFluidStack();
    }

    public int getTankCapacity(int i) {
        return (int)this.container.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.getFluidInTank(i).isFluidEqual(fluidStack);
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        long filled = this.container.insertFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate());
        ((Updatable)this.container).update(this.itemStack);
        return (int)filled;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidStack drained = new ForgeFluidHolder(this.container.extractFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate())).getFluidStack();
        ((Updatable)this.container).update(this.itemStack);
        return drained;
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        FluidHolder fluid = this.container.getFluids().get(0).copyHolder();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(i);
        ((Updatable)this.container).update(this.itemStack);
        return new ForgeFluidHolder(this.container.extractFluid(fluid, fluidAction.simulate())).getFluidStack();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        LazyOptional of = LazyOptional.of((NonNullSupplier)(this.container.getContainer(arg) != null ? () -> this : null));
        return capability.orEmpty(ForgeCapabilities.FLUID_HANDLER_ITEM, of.cast()).cast();
    }
}

