/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge;

import earth.terrarium.botarium.Botarium;
import earth.terrarium.botarium.common.energy.base.EnergyAttachment;
import earth.terrarium.botarium.common.fluid.base.FluidAttachment;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.ItemFluidContainer;
import earth.terrarium.botarium.common.item.ItemContainerBlock;
import earth.terrarium.botarium.forge.energy.ForgeEnergyContainer;
import earth.terrarium.botarium.forge.energy.ForgeItemEnergyContainer;
import earth.terrarium.botarium.forge.fluid.ForgeFluidContainer;
import earth.terrarium.botarium.forge.fluid.ForgeItemFluidContainer;
import earth.terrarium.botarium.forge.item.ItemContainerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod(value="botarium")
public class BotariumForge {
    public BotariumForge() {
        Botarium.init();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(BlockEntity.class, BotariumForge::attachBlockCapabilities);
        bus.addGenericListener(ItemStack.class, BotariumForge::attachItemCapabilities);
    }

    public static void attachBlockCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
        FluidAttachment fluidHoldingBlock;
        EnergyAttachment energyBlock;
        Object object = event.getObject();
        if (object instanceof EnergyAttachment && (energyBlock = (EnergyAttachment)object).getEnergyHolderType() == BlockEntity.class) {
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeEnergyContainer(energyBlock.getEnergyStorage(event.getObject()), (BlockEntity)event.getObject()));
        }
        if ((object = event.getObject()) instanceof FluidAttachment && (fluidHoldingBlock = (FluidAttachment)object).getFluidHolderType() == BlockEntity.class) {
            event.addCapability(new ResourceLocation("botarium", "fluid"), (ICapabilityProvider)new ForgeFluidContainer((FluidContainer)fluidHoldingBlock.getFluidContainer(event.getObject())));
        }
        if ((object = event.getObject()) instanceof ItemContainerBlock) {
            ItemContainerBlock itemContainerBlock = (ItemContainerBlock)object;
            event.addCapability(new ResourceLocation("botarium", "item"), (ICapabilityProvider)new ItemContainerWrapper(itemContainerBlock.getContainer()));
        }
    }

    public static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        FluidAttachment fluidAttachment;
        Object t;
        FluidAttachment fluidHoldingItem;
        EnergyAttachment energyItem;
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (item instanceof EnergyAttachment && (energyItem = (EnergyAttachment)item).getEnergyHolderType() == ItemStack.class) {
            event.addCapability(new ResourceLocation("botarium", "energy"), new ForgeItemEnergyContainer(energyItem.getEnergyStorage(event.getObject()), (ItemStack)event.getObject()));
        }
        if ((item = ((ItemStack)event.getObject()).m_41720_()) instanceof FluidAttachment && (fluidHoldingItem = (FluidAttachment)item).getFluidHolderType() == ItemStack.class && (t = (fluidAttachment = fluidHoldingItem).getFluidContainer((ItemStack)event.getObject())) instanceof ItemFluidContainer) {
            ItemFluidContainer fluidContainer = (ItemFluidContainer)t;
            event.addCapability(new ResourceLocation("botarium", "fluid"), new ForgeItemFluidContainer<ItemFluidContainer>(fluidContainer, (ItemStack)event.getObject()));
        }
    }
}

