/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.registry.fluid;

import earth.terrarium.botarium.common.registry.fluid.FluidData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidBucketItem
extends BucketItem {
    private final FluidData data;

    public FluidBucketItem(FluidData data, Item.Properties properties) {
        super(() -> (Fluid)data.getStillFluid().get(), properties);
        this.data = data;
        data.setBucket(() -> this);
    }

    public FluidData getData() {
        return this.data;
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (this.getData().getProperties().canPlace()) {
            return super.m_7203_(level, player, hand);
        }
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }

    protected void m_7718_(@Nullable Player player, @NotNull LevelAccessor level, @NotNull BlockPos pos) {
        SoundEvent event = this.getData().getProperties().sounds().getSound("bucket_empty");
        if (event == null) {
            event = SoundEvents.f_11778_;
        }
        level.m_5594_(player, pos, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
    }

    public ICapabilityProvider initCapabilities(@NotNull ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack);
    }
}

