/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;

public interface FluidHolder {
    public static final Codec<FluidHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf("fluid").forGetter(FluidHolder::getFluid), (App)Codec.FLOAT.fieldOf("buckets").orElse((Object)Float.valueOf(1.0f)).forGetter(fluidHolder -> Float.valueOf((float)fluidHolder.getFluidAmount() / (float)FluidHooks.getBucketAmount())), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(fluidHolder -> Optional.ofNullable(fluidHolder.getCompound()))).apply((Applicative)instance, (fluid, buckets, compoundTag) -> FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets.floatValue()), compoundTag.orElse(null))));

    public static FluidHolder of(Fluid fluid) {
        return FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(1.0), null);
    }

    public static FluidHolder of(Fluid fluid, double buckets, CompoundTag tag) {
        return FluidHooks.newFluidHolder(fluid, FluidHooks.buckets(buckets), tag);
    }

    public Fluid getFluid();

    public void setFluid(Fluid var1);

    public long getFluidAmount();

    public void setAmount(long var1);

    public CompoundTag getCompound();

    public void setCompound(CompoundTag var1);

    public boolean isEmpty();

    public boolean matches(FluidHolder var1);

    public FluidHolder copyHolder();

    public CompoundTag serialize();

    public void deserialize(CompoundTag var1);

    default public FluidHolder copyWithAmount(long amount) {
        FluidHolder copy = this.copyHolder();
        if (!copy.isEmpty()) {
            copy.setAmount(amount);
        }
        return copy;
    }
}

