/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.treedecorator;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.treedecorator.AetherTreeDecoratorTypes;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class HolidayTreeDecorator
extends TreeDecorator {
    public static final Codec<HolidayTreeDecorator> CODEC = BlockStateProvider.f_68747_.fieldOf("provider").xmap(HolidayTreeDecorator::new, instance -> instance.provider).codec();
    private final BlockStateProvider provider;

    public HolidayTreeDecorator(BlockStateProvider provider) {
        this.provider = provider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return (TreeDecoratorType)AetherTreeDecoratorTypes.HOLIDAY_TREE_DECORATOR.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        ObjectArrayList logPositions = context.m_226068_();
        if (!logPositions.isEmpty()) {
            int i = ((BlockPos)logPositions.get(0)).m_123342_();
            logPositions.stream().filter(logs -> logs.m_123342_() == i).forEach(logPos -> this.placeCircle(context, (BlockPos)logPos));
        }
    }

    private void placeCircle(TreeDecorator.Context context, BlockPos pPos) {
        LevelSimulatedReader level = context.m_226058_();
        RandomSource random = context.m_226067_();
        this.placeBlockAt(context, level, random, pPos, 0.0f);
        int radius = 10;
        for (int z = 1; z < radius; ++z) {
            for (int x = 0; x < radius; ++x) {
                if (x * x + z * z > radius * radius) continue;
                float distance = (float)Math.sqrt(x * x + z * z) / (float)(radius * radius);
                this.placeBlockAt(context, level, random, pPos.m_7918_(x, 0, z), distance);
                this.placeBlockAt(context, level, random, pPos.m_7918_(-x, 0, -z), distance);
                this.placeBlockAt(context, level, random, pPos.m_7918_(-z, 0, x), distance);
                this.placeBlockAt(context, level, random, pPos.m_7918_(z, 0, -x), distance);
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context context, LevelSimulatedReader pLevel, RandomSource pRandom, BlockPos pPos, float distance) {
        for (int i = 9; i >= -4; --i) {
            BlockPos blockpos = pPos.m_6630_(i);
            if (!context.m_226059_(blockpos.m_7494_()) || !pLevel.m_7433_(blockpos, HolidayTreeDecorator::isAetherGrass) && !pLevel.m_7433_(blockpos, HolidayTreeDecorator::isLeaves) && !Feature.m_65788_((LevelSimulatedReader)pLevel, (BlockPos)blockpos) || !context.m_226059_(blockpos.m_6630_(4)) || !(distance <= pRandom.m_188501_() / 2.0f * (1.0f - distance))) continue;
            if (pLevel.m_7433_(blockpos, HolidayTreeDecorator::isLeaves)) {
                context.m_226061_(blockpos.m_7494_(), Blocks.f_50125_.m_49966_());
                continue;
            }
            context.m_226061_(blockpos.m_7494_(), this.provider.m_213972_(pRandom, blockpos));
        }
    }

    private static boolean isAetherGrass(BlockState state) {
        return state.m_204336_(AetherTags.Blocks.AETHER_DIRT);
    }

    private static boolean isLeaves(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_);
    }
}

