/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.bronzedungeon.BronzeDungeonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class BronzeDungeonStructure
extends Structure {
    public static final Codec<BronzeDungeonStructure> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BronzeDungeonStructure.m_226567_((RecordCodecBuilder.Instance)builder), (App)Codec.INT.fieldOf("maxrooms").forGetter(o -> o.maxRooms)).apply((Applicative)builder, BronzeDungeonStructure::new));
    private final int maxRooms;

    public BronzeDungeonStructure(Structure.StructureSettings settings, int maxRooms) {
        super(settings);
        this.maxRooms = maxRooms;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        StructureTemplateManager templateManager;
        RandomState randomState;
        LevelHeightAccessor heightAccessor;
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        int height = BronzeDungeonStructure.findStartingHeight(chunkGenerator, heightAccessor = context.f_226629_(), chunkPos, randomState = context.f_226624_(), templateManager = context.f_226625_());
        if (height <= heightAccessor.m_141937_()) {
            MutableInt y = new MutableInt(height);
            chunkPos = BronzeDungeonStructure.searchNearbyChunks(chunkPos, y, chunkGenerator, heightAccessor, randomState, templateManager);
            height = y.getValue();
            if (height <= heightAccessor.m_141937_()) {
                return Optional.empty();
            }
        }
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), height, chunkPos.m_45605_());
        return Optional.of(new Structure.GenerationStub(blockPos, builder -> this.generatePieces((StructurePiecesBuilder)builder, context, blockPos)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos startPos) {
        BronzeDungeonBuilder graph = new BronzeDungeonBuilder(context, this.maxRooms);
        graph.initializeDungeon(startPos, context.f_226628_(), builder);
    }

    private static ChunkPos searchNearbyChunks(ChunkPos chunkPos, MutableInt height, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, StructureTemplateManager templateManager) {
        block0: for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                ChunkPos offset;
                int y;
                if (x == 0 && z == 0 || (y = BronzeDungeonStructure.findStartingHeight(chunkGenerator, heightAccessor, offset = new ChunkPos(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z), randomState, templateManager)) <= heightAccessor.m_141937_()) continue;
                chunkPos = offset;
                height.setValue(y);
                continue block0;
            }
        }
        return chunkPos;
    }

    private static int findStartingHeight(ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, ChunkPos chunkPos, RandomState random, StructureTemplateManager manager) {
        int minX = chunkPos.m_45604_() - 1;
        int minZ = chunkPos.m_45605_() - 1;
        int maxX = chunkPos.m_45608_() + 1;
        int maxZ = chunkPos.m_45609_() + 1;
        NoiseColumn[] columns = new NoiseColumn[]{chunkGenerator.m_214184_(minX, minZ, heightAccessor, random), chunkGenerator.m_214184_(minX, maxZ, heightAccessor, random), chunkGenerator.m_214184_(maxX, minZ, heightAccessor, random), chunkGenerator.m_214184_(maxX, maxZ, heightAccessor, random)};
        int roomHeight = BronzeDungeonStructure.checkRoomHeight(manager, new ResourceLocation("aether", "bronze_dungeon/boss_room"));
        int height = heightAccessor.m_141937_();
        int maxHeight = heightAccessor.m_151558_() - 24;
        int thickness = roomHeight + 2;
        int currentThickness = 0;
        for (int y = height + 32; y <= maxHeight; ++y) {
            if (BronzeDungeonStructure.checkEachCornerAtY(columns, y)) {
                ++currentThickness;
                continue;
            }
            if (currentThickness > thickness) {
                thickness = currentThickness;
                height = y;
            }
            currentThickness = 0;
        }
        int offset = (thickness + roomHeight) / 2;
        return height -= offset;
    }

    private static int checkRoomHeight(StructureTemplateManager manager, ResourceLocation roomName) {
        StructureTemplate template = manager.m_230359_(roomName);
        return template.m_163801_().m_123342_();
    }

    private static boolean checkEachCornerAtY(NoiseColumn[] columns, int y) {
        for (NoiseColumn column : columns) {
            if (!column.m_183556_(y).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public BoundingBox m_226569_(BoundingBox box) {
        return box;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AetherStructureTypes.BRONZE_DUNGEON.get();
    }
}

