/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.util;

import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateRecipeUtil {
    public static void executeFunction(Level level, BlockPos pos, CommandFunction.CacheableFunction function) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (function != null) {
                MinecraftServer minecraftServer = serverLevel.m_7654_();
                function.m_78002_(minecraftServer.m_129890_()).ifPresent(command -> {
                    CommandSourceStack context = minecraftServer.m_129890_().m_136129_().m_81348_(Vec3.m_82539_((Vec3i)pos)).m_81327_(serverLevel);
                    minecraftServer.m_129890_().m_136112_(command, context);
                });
            }
        }
    }

    public static void writePair(FriendlyByteBuf buffer, BlockPropertyPair pair) {
        ResourceLocation blockLocation = ForgeRegistries.BLOCKS.getKey((Object)pair.block());
        if (pair.block().m_49966_().m_60795_() && pair.properties().isEmpty() || blockLocation == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130070_(blockLocation.toString());
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<Property<?>, Comparable<?>> entry : pair.properties().entrySet()) {
                Property<?> property = entry.getKey();
                tag.m_128359_(property.m_61708_(), BlockStateRecipeUtil.getName(property, entry.getValue()));
            }
            buffer.m_130079_(tag);
        }
    }

    public static void writeBiomeKey(FriendlyByteBuf buffer, ResourceKey<Biome> biomeKey) {
        if (biomeKey == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130085_(biomeKey.m_135782_());
        }
    }

    public static void writeBiomeTag(FriendlyByteBuf buffer, TagKey<Biome> biomeTag) {
        if (biomeTag == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130085_(biomeTag.f_203868_());
        }
    }

    public static BlockPropertyPair readPair(FriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return BlockPropertyPair.of(Blocks.f_50016_, new HashMap());
        }
        String blockString = buffer.m_130277_();
        ResourceLocation blockLocation = new ResourceLocation(blockString);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
        if (block == null) {
            throw new JsonSyntaxException("Unknown block '" + blockLocation + "'");
        }
        HashMap properties = new HashMap();
        CompoundTag tag = buffer.m_130260_();
        if (tag != null) {
            for (String propertyName : tag.m_128431_()) {
                Property property = block.m_49965_().m_61081_(propertyName);
                if (property == null) continue;
                Optional comparable = property.m_6215_(propertyName);
                comparable.ifPresent(value -> properties.put((Property<?>)property, (Comparable<?>)value));
            }
        }
        return BlockPropertyPair.of(block, properties);
    }

    public static ResourceKey<Biome> readBiomeKey(FriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        ResourceLocation biomeLocation = buffer.m_130281_();
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)biomeLocation);
    }

    public static TagKey<Biome> readBiomeTag(FriendlyByteBuf buffer) {
        if (!buffer.readBoolean()) {
            return null;
        }
        ResourceLocation tagLocation = buffer.m_130281_();
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagLocation);
    }

    public static CommandFunction.CacheableFunction readFunction(FriendlyByteBuf buffer) {
        String functionString = buffer.m_130277_();
        ResourceLocation functionLocation = functionString.isEmpty() ? null : new ResourceLocation(functionString);
        return functionLocation == null ? CommandFunction.CacheableFunction.f_77990_ : new CommandFunction.CacheableFunction(functionLocation);
    }

    public static void biomeKeyToJson(JsonObject json, ResourceKey<Biome> biomeKey) {
        if (biomeKey != null) {
            ResourceLocation biomeLocation = biomeKey.m_135782_();
            json.addProperty("biome", biomeLocation.toString());
        }
    }

    public static void biomeTagToJson(JsonObject json, TagKey<Biome> biomeTag) {
        if (biomeTag != null) {
            ResourceLocation tagLocation = biomeTag.f_203868_();
            json.addProperty("biome", "#" + tagLocation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BlockPropertyPair pairFromJson(JsonObject json) {
        Map<Property<?>, Comparable<?>> properties = Map.of();
        if (!json.has("block")) throw new JsonSyntaxException("Missing block in result");
        Block block = BlockStateRecipeUtil.blockFromJson(json);
        if (!json.has("properties")) return BlockPropertyPair.of(block, properties);
        if (!json.get("properties").isJsonObject()) throw new JsonSyntaxException("Expected properties to be object");
        properties = BlockStateRecipeUtil.propertiesFromJson(json, block);
        return BlockPropertyPair.of(block, properties);
    }

    public static Block blockFromJson(JsonObject json) {
        String blockName = GsonHelper.m_13906_((JsonObject)json, (String)"block");
        ResourceLocation blockLocation = new ResourceLocation(blockName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(blockLocation);
        if (block == null) {
            throw new JsonSyntaxException("Unknown block '" + blockLocation + "'");
        }
        if (block.m_49966_().m_60795_()) {
            throw new JsonSyntaxException("Invalid block: " + blockLocation);
        }
        return block;
    }

    public static Map<Property<?>, Comparable<?>> propertiesFromJson(JsonObject json, Block block) {
        HashMap properties = new HashMap();
        StateDefinition stateDefinition = block.m_49965_();
        JsonObject propertyObject = GsonHelper.m_13930_((JsonObject)json, (String)"properties");
        for (String propertyName : propertyObject.keySet()) {
            Property property = stateDefinition.m_61081_(propertyName);
            String valueName = GsonHelper.m_13906_((JsonObject)propertyObject, (String)propertyName);
            if (property == null) continue;
            Optional comparable = property.m_6215_(valueName);
            comparable.ifPresent(value -> properties.put((Property<?>)property, (Comparable<?>)value));
        }
        return properties;
    }

    public static Pair<ResourceKey<Biome>, TagKey<Biome>> biomeRecipeDataFromJson(JsonObject json) {
        ResourceKey<Biome> biomeKey = null;
        TagKey<Biome> biomeTag = null;
        if (json.has("biome")) {
            String biomeName = GsonHelper.m_13906_((JsonObject)json, (String)"biome");
            if (biomeName.startsWith("#")) {
                biomeTag = BlockStateRecipeUtil.biomeTagFromJson(json);
            } else {
                biomeKey = BlockStateRecipeUtil.biomeKeyFromJson(json);
            }
        }
        return Pair.of(biomeKey, biomeTag);
    }

    public static ResourceKey<Biome> biomeKeyFromJson(JsonObject json) {
        String biomeName = GsonHelper.m_13906_((JsonObject)json, (String)"biome");
        String[] nameWithId = biomeName.split(":");
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)(nameWithId.length > 1 ? new ResourceLocation(nameWithId[0], nameWithId[1]) : new ResourceLocation(biomeName)));
    }

    public static TagKey<Biome> biomeTagFromJson(JsonObject json) {
        String biomeName = GsonHelper.m_13906_((JsonObject)json, (String)"biome").replace("#", "");
        String[] nameWithId = biomeName.split(":");
        return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)(nameWithId.length > 1 ? new ResourceLocation(nameWithId[0], nameWithId[1]) : new ResourceLocation(biomeName)));
    }

    public static <T extends Comparable<T>, V extends T> BlockState setHelper(Map.Entry<Property<?>, Comparable<?>> properties, BlockState state) {
        return (BlockState)state.m_61124_(properties.getKey(), properties.getValue());
    }

    public static <T extends Comparable<T>> String getName(Property<T> pProperty, Comparable<?> pValue) {
        return pProperty.m_6940_(pValue);
    }
}

