/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.block.AbstractBlockStateRecipe;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class BlockStateRecipeSerializer<T extends AbstractBlockStateRecipe>
implements RecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public BlockStateRecipeSerializer(CookieBaker<T> factory) {
        this.factory = factory;
    }

    public T fromJson(ResourceLocation id, JsonObject json) {
        if (!json.has("ingredient")) {
            throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
        }
        JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
        BlockStateIngredient ingredient = BlockStateIngredient.fromJson((JsonElement)jsonElement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (!json.get("result").isJsonObject()) {
            throw new JsonSyntaxException("Expected result to be object");
        }
        JsonObject resultObject = json.getAsJsonObject("result");
        BlockPropertyPair result = BlockStateRecipeUtil.pairFromJson(resultObject);
        String functionString = GsonHelper.m_13851_((JsonObject)json, (String)"mcfunction", null);
        ResourceLocation functionLocation = functionString == null ? null : new ResourceLocation(functionString);
        CommandFunction.CacheableFunction function = functionLocation == null ? CommandFunction.CacheableFunction.f_77990_ : new CommandFunction.CacheableFunction(functionLocation);
        return this.factory.create(id, ingredient, result, function);
    }

    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork(buffer);
        BlockPropertyPair result = BlockStateRecipeUtil.readPair(buffer);
        CommandFunction.CacheableFunction function = BlockStateRecipeUtil.readFunction(buffer);
        return this.factory.create(id, ingredient, result, function);
    }

    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        ((AbstractBlockStateRecipe)recipe).getIngredient().toNetwork(buffer);
        BlockStateRecipeUtil.writePair(buffer, ((AbstractBlockStateRecipe)recipe).getResult());
        CommandFunction.CacheableFunction function = ((AbstractBlockStateRecipe)recipe).getFunction();
        buffer.m_130070_(function != null && function.m_77999_() != null ? function.m_77999_().toString() : "");
    }

    public static interface CookieBaker<T extends AbstractBlockStateRecipe> {
        public T create(ResourceLocation var1, BlockStateIngredient var2, BlockPropertyPair var3, CommandFunction.CacheableFunction var4);
    }
}

