/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.serializer;

import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.block.AbstractBiomeParameterRecipe;
import com.aetherteam.aether.recipe.serializer.BlockStateRecipeSerializer;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.apache.commons.lang3.tuple.Pair;

public class BiomeParameterRecipeSerializer<T extends AbstractBiomeParameterRecipe>
extends BlockStateRecipeSerializer<T> {
    private final CookieBaker<T> factory;

    public BiomeParameterRecipeSerializer(CookieBaker<T> factory, BlockStateRecipeSerializer.CookieBaker<T> superFactory) {
        super(superFactory);
        this.factory = factory;
    }

    @Override
    public T fromJson(ResourceLocation id, JsonObject json) {
        Pair<ResourceKey<Biome>, TagKey<Biome>> biomeRecipeData = BlockStateRecipeUtil.biomeRecipeDataFromJson(json);
        ResourceKey biomeKey = (ResourceKey)biomeRecipeData.getLeft();
        TagKey biomeTag = (TagKey)biomeRecipeData.getRight();
        AbstractBiomeParameterRecipe recipe = (AbstractBiomeParameterRecipe)super.fromJson(id, json);
        return this.factory.create(id, (ResourceKey<Biome>)biomeKey, (TagKey<Biome>)biomeTag, recipe.getIngredient(), recipe.getResult(), recipe.getFunction());
    }

    @Override
    @Nullable
    public T fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        ResourceKey<Biome> biomeKey = BlockStateRecipeUtil.readBiomeKey(buffer);
        TagKey<Biome> biomeTag = BlockStateRecipeUtil.readBiomeTag(buffer);
        BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork(buffer);
        BlockPropertyPair result = BlockStateRecipeUtil.readPair(buffer);
        CommandFunction.CacheableFunction function = BlockStateRecipeUtil.readFunction(buffer);
        return this.factory.create(id, biomeKey, biomeTag, ingredient, result, function);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, T recipe) {
        BlockStateRecipeUtil.writeBiomeKey(buffer, ((AbstractBiomeParameterRecipe)recipe).getBiomeKey());
        BlockStateRecipeUtil.writeBiomeTag(buffer, ((AbstractBiomeParameterRecipe)recipe).getBiomeTag());
        super.toNetwork(buffer, recipe);
    }

    public static interface CookieBaker<T extends AbstractBiomeParameterRecipe> {
        public T create(ResourceLocation var1, @Nullable ResourceKey<Biome> var2, @Nullable TagKey<Biome> var3, BlockStateIngredient var4, BlockPropertyPair var5, CommandFunction.CacheableFunction var6);
    }
}

