/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.block;

import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.block.BlockStateRecipe;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import java.util.Map;
import net.minecraft.commands.CommandFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractBlockStateRecipe
implements BlockStateRecipe {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final BlockStateIngredient ingredient;
    protected final BlockPropertyPair result;
    protected final CommandFunction.CacheableFunction function;

    public AbstractBlockStateRecipe(RecipeType<?> type, ResourceLocation id, BlockStateIngredient ingredient, BlockPropertyPair result, CommandFunction.CacheableFunction function) {
        this.type = type;
        this.id = id;
        this.ingredient = ingredient;
        this.result = result;
        this.function = function;
    }

    public boolean set(Level level, BlockPos pos, BlockState oldState) {
        if (this.matches(level, pos, oldState)) {
            BlockState newState = this.getResultState(oldState);
            level.m_46597_(pos, newState);
            BlockStateRecipeUtil.executeFunction(level, pos, this.getFunction());
            return true;
        }
        return false;
    }

    public boolean matches(Level level, BlockPos pos, BlockState state) {
        return this.getIngredient().test(state);
    }

    @Override
    public BlockState getResultState(BlockState originalState) {
        BlockState resultState = this.getResult().block().m_152465_(originalState);
        for (Map.Entry<Property<?>, Comparable<?>> propertyEntry : this.getResult().properties().entrySet()) {
            resultState = BlockStateRecipeUtil.setHelper(propertyEntry, resultState);
        }
        return resultState;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public BlockStateIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public BlockPropertyPair getResult() {
        return this.result;
    }

    @Override
    public CommandFunction.CacheableFunction getFunction() {
        return this.function;
    }
}

