/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.ban;

import com.aetherteam.aether.event.dispatch.AetherEventDispatch;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.aether.recipe.serializer.PlacementBanRecipeSerializer;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class ItemBanRecipe
extends AbstractPlacementBanRecipe<ItemStack, Ingredient> {
    public ItemBanRecipe(ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, BlockStateIngredient bypassBlock, Ingredient ingredient) {
        super((RecipeType)AetherRecipeTypes.ITEM_PLACEMENT_BAN.get(), id, biomeKey, biomeTag, bypassBlock, ingredient);
    }

    public ItemBanRecipe(ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, BlockStateIngredient bypassBlock) {
        this(id, biomeKey, biomeTag, bypassBlock, Ingredient.f_43901_);
    }

    public boolean banItem(Level level, BlockPos pos, Direction direction, ItemStack stack, boolean spawnParticles) {
        if (this.matches(level, pos, stack) && AetherEventDispatch.isItemPlacementBanned((LevelAccessor)level, pos, stack)) {
            if (spawnParticles) {
                AetherEventDispatch.onPlacementSpawnParticles((LevelAccessor)level, pos, direction, stack, null);
            }
            return true;
        }
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AetherRecipeSerializers.ITEM_PLACEMENT_BAN.get();
    }

    public static class Serializer
    extends PlacementBanRecipeSerializer<ItemStack, Ingredient, ItemBanRecipe> {
        public Serializer() {
            super(ItemBanRecipe::new);
        }

        @Override
        public ItemBanRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemBanRecipe recipe = (ItemBanRecipe)super.fromJson(id, json);
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
            }
            JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonElement);
            return new ItemBanRecipe(id, recipe.getBiomeKey(), recipe.getBiomeTag(), recipe.getBypassBlock(), ingredient);
        }

        @Override
        @Nullable
        public ItemBanRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ResourceKey<Biome> biomeKey = BlockStateRecipeUtil.readBiomeKey(buffer);
            TagKey<Biome> biomeTag = BlockStateRecipeUtil.readBiomeTag(buffer);
            BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork(buffer);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new ItemBanRecipe(id, biomeKey, biomeTag, bypassBlock, ingredient);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, ItemBanRecipe recipe) {
            super.toNetwork(buffer, recipe);
            ((Ingredient)recipe.getIngredient()).m_43923_(buffer);
        }
    }
}

