/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe.recipes.ban;

import com.aetherteam.aether.event.dispatch.AetherEventDispatch;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.BlockStateIngredient;
import com.aetherteam.aether.recipe.recipes.ban.AbstractPlacementBanRecipe;
import com.aetherteam.aether.recipe.serializer.PlacementBanRecipeSerializer;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public class BlockBanRecipe
extends AbstractPlacementBanRecipe<BlockState, BlockStateIngredient> {
    public BlockBanRecipe(ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, BlockStateIngredient bypassBlock, BlockStateIngredient ingredient) {
        super((RecipeType)AetherRecipeTypes.BLOCK_PLACEMENT_BAN.get(), id, biomeKey, biomeTag, bypassBlock, ingredient);
    }

    public BlockBanRecipe(ResourceLocation id, @Nullable ResourceKey<Biome> biomeKey, @Nullable TagKey<Biome> biomeTag, BlockStateIngredient bypassBlock) {
        this(id, biomeKey, biomeTag, bypassBlock, BlockStateIngredient.EMPTY);
    }

    public boolean banBlock(Level level, BlockPos pos, BlockState state) {
        if (this.matches(level, pos.m_7495_(), state) && AetherEventDispatch.isBlockPlacementBanned((LevelAccessor)level, pos, state)) {
            AetherEventDispatch.onPlacementSpawnParticles((LevelAccessor)level, pos, null, null, state);
            return true;
        }
        return false;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)AetherRecipeSerializers.BLOCK_PLACEMENT_BAN.get();
    }

    public static class Serializer
    extends PlacementBanRecipeSerializer<BlockState, BlockStateIngredient, BlockBanRecipe> {
        public Serializer() {
            super(BlockBanRecipe::new);
        }

        @Override
        public BlockBanRecipe fromJson(ResourceLocation id, JsonObject json) {
            BlockBanRecipe recipe = (BlockBanRecipe)super.fromJson(id, json);
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Missing ingredient, expected to find an object or array");
            }
            JsonArray jsonElement = GsonHelper.m_13885_((JsonObject)json, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)json, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)json, (String)"ingredient");
            BlockStateIngredient ingredient = BlockStateIngredient.fromJson((JsonElement)jsonElement);
            return new BlockBanRecipe(id, recipe.getBiomeKey(), recipe.getBiomeTag(), recipe.getBypassBlock(), ingredient);
        }

        @Override
        @Nullable
        public BlockBanRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ResourceKey<Biome> biomeKey = BlockStateRecipeUtil.readBiomeKey(buffer);
            TagKey<Biome> biomeTag = BlockStateRecipeUtil.readBiomeTag(buffer);
            BlockStateIngredient bypassBlock = BlockStateIngredient.fromNetwork(buffer);
            BlockStateIngredient ingredient = BlockStateIngredient.fromNetwork(buffer);
            return new BlockBanRecipe(id, biomeKey, biomeTag, bypassBlock, ingredient);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, BlockBanRecipe recipe) {
            super.toNetwork(buffer, recipe);
            ((BlockStateIngredient)recipe.getIngredient()).toNetwork(buffer);
        }
    }
}

