/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.recipe;

import com.aetherteam.aether.recipe.BlockPropertyPair;
import com.aetherteam.aether.util.BlockStateRecipeUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class BlockStateIngredient
implements Predicate<BlockState> {
    public static final BlockStateIngredient EMPTY = new BlockStateIngredient(Stream.empty());
    private final Value[] values;
    @Nullable
    private BlockPropertyPair[] pairs;

    protected BlockStateIngredient(Stream<? extends Value> values) {
        this.values = (Value[])values.toArray(Value[]::new);
    }

    private void dissolve() {
        if (this.pairs == null) {
            this.pairs = (BlockPropertyPair[])Arrays.stream(this.values).flatMap(value -> value.getPairs().stream()).distinct().toArray(BlockPropertyPair[]::new);
        }
    }

    @Override
    public boolean test(BlockState state) {
        this.dissolve();
        if (this.pairs.length != 0) {
            for (BlockPropertyPair pair : this.pairs) {
                if (!pair.matches(state)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.values.length == 0 && (this.pairs == null || this.pairs.length == 0);
    }

    @Nullable
    public BlockPropertyPair[] getPairs() {
        this.dissolve();
        return this.pairs;
    }

    public static BlockStateIngredient of() {
        return EMPTY;
    }

    public static BlockStateIngredient of(BlockPropertyPair ... blockPropertyPairs) {
        return BlockStateIngredient.ofBlockPropertyPair(Arrays.stream(blockPropertyPairs));
    }

    public static BlockStateIngredient ofBlockPropertyPair(Stream<BlockPropertyPair> blockPropertyPairs) {
        return BlockStateIngredient.fromValues(blockPropertyPairs.filter(pair -> !pair.block().m_49966_().m_60795_()).map(StateValue::new));
    }

    public static BlockStateIngredient of(Block ... blocks) {
        return BlockStateIngredient.ofBlock(Arrays.stream(blocks));
    }

    public static BlockStateIngredient ofBlock(Stream<Block> blocks) {
        return BlockStateIngredient.fromValues(blocks.filter(block -> !block.m_49966_().m_60795_()).map(BlockValue::new));
    }

    public static BlockStateIngredient of(TagKey<Block> tag) {
        return BlockStateIngredient.fromValues(Stream.of(new TagValue(tag)));
    }

    public final void toNetwork(FriendlyByteBuf buf) {
        this.dissolve();
        buf.m_236828_(Arrays.asList(this.pairs), BlockStateRecipeUtil::writePair);
    }

    public static BlockStateIngredient fromNetwork(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        return BlockStateIngredient.fromValues(Stream.generate(() -> {
            BlockPropertyPair pair = BlockStateRecipeUtil.readPair(buf);
            return new StateValue(pair.block(), pair.properties());
        }).limit(size));
    }

    public JsonElement toJson() {
        if (this.values.length == 1) {
            return this.values[0].serialize();
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        return jsonArray;
    }

    public static BlockStateIngredient fromJson(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return BlockStateIngredient.fromValues(Stream.of(BlockStateIngredient.valueFromJson(json.getAsJsonObject())));
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    throw new JsonSyntaxException("Block array cannot be empty, at least one item must be defined");
                }
                return BlockStateIngredient.fromValues(StreamSupport.stream(jsonArray.spliterator(), false).map(element -> BlockStateIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)element, (String)"block"))));
            }
            throw new JsonSyntaxException("Expected block to be object or array of objects");
        }
        throw new JsonSyntaxException("Block cannot be null");
    }

    public static Value valueFromJson(JsonObject json) {
        if (json.has("block") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or a block, not both");
        }
        if (json.has("block")) {
            Block block = BlockStateRecipeUtil.blockFromJson(json);
            if (json.has("properties")) {
                Map<Property<?>, Comparable<?>> properties = BlockStateRecipeUtil.propertiesFromJson(json, block);
                return new StateValue(block, properties);
            }
            return new BlockValue(block);
        }
        if (json.has("tag")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)resourcelocation);
            return new TagValue((TagKey<Block>)tagKey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or a block");
    }

    public static BlockStateIngredient fromValues(Stream<? extends Value> stream) {
        BlockStateIngredient ingredient = new BlockStateIngredient(stream);
        return ingredient.values.length == 0 ? EMPTY : ingredient;
    }

    public static interface Value {
        public Collection<BlockPropertyPair> getPairs();

        public JsonObject serialize();
    }

    public static class TagValue
    implements Value {
        private final TagKey<Block> tag;

        public TagValue(TagKey<Block> tag) {
            this.tag = tag;
        }

        @Override
        public Collection<BlockPropertyPair> getPairs() {
            ArrayList<BlockPropertyPair> list = new ArrayList<BlockPropertyPair>();
            ITagManager tags = ForgeRegistries.BLOCKS.tags();
            if (tags != null) {
                tags.getTag(this.tag).stream().forEach(block -> list.add(BlockPropertyPair.of(block, Map.of())));
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonobject = new JsonObject();
            jsonobject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonobject;
        }
    }

    public static class StateValue
    implements Value {
        private final Block block;
        private final Map<Property<?>, Comparable<?>> properties;

        public StateValue(Block block, Map<Property<?>, Comparable<?>> properties) {
            this.block = block;
            this.properties = properties;
        }

        public StateValue(BlockPropertyPair blockPropertyPair) {
            this.block = blockPropertyPair.block();
            this.properties = blockPropertyPair.properties();
        }

        @Override
        public Collection<BlockPropertyPair> getPairs() {
            return Collections.singleton(BlockPropertyPair.of(this.block, this.properties));
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            ResourceLocation blockLocation = ForgeRegistries.BLOCKS.getKey((Object)this.block);
            if (blockLocation == null) {
                throw new JsonParseException("Block for ingredient StateValue serialization shouldn't be null");
            }
            jsonObject.addProperty("block", blockLocation.toString());
            JsonObject jsonObject1 = new JsonObject();
            if (!this.properties.isEmpty()) {
                for (Map.Entry<Property<?>, Comparable<?>> entry : this.properties.entrySet()) {
                    Property<?> property = entry.getKey();
                    jsonObject1.addProperty(property.m_61708_(), BlockStateRecipeUtil.getName(property, entry.getValue()));
                }
            }
            jsonObject.add("properties", (JsonElement)jsonObject1);
            return jsonObject;
        }
    }

    public static class BlockValue
    implements Value {
        private final Block block;

        public BlockValue(Block block) {
            this.block = block;
        }

        @Override
        public Collection<BlockPropertyPair> getPairs() {
            return Collections.singleton(BlockPropertyPair.of(this.block, Map.of()));
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            ResourceLocation blockLocation = ForgeRegistries.BLOCKS.getKey((Object)this.block);
            if (blockLocation == null) {
                throw new JsonParseException("Block for ingredient StateValue serialization shouldn't be null");
            }
            jsonObject.addProperty("block", blockLocation.toString());
            return jsonObject;
        }
    }
}

