/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.client;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.entity.miscellaneous.CloudMinion;
import com.aetherteam.aether.network.AetherPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record CloudMinionPacket(int entityID, int rightCloudMinionID, int leftCloudMinionID) implements AetherPacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.rightCloudMinionID);
        buf.writeInt(this.leftCloudMinionID);
    }

    public static CloudMinionPacket decode(FriendlyByteBuf buf) {
        int entityID = buf.readInt();
        int rightCloudMinionID = buf.readInt();
        int leftCloudMinionID = buf.readInt();
        return new CloudMinionPacket(entityID, rightCloudMinionID, leftCloudMinionID);
    }

    @Override
    public void execute(Player playerEntity) {
        Level world;
        Entity entity;
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null && (entity = (world = Minecraft.m_91087_().f_91074_.f_19853_).m_6815_(this.entityID)) instanceof Player) {
            Player player = (Player)entity;
            entity = world.m_6815_(this.rightCloudMinionID);
            if (entity instanceof CloudMinion) {
                CloudMinion cloudMinionRight = (CloudMinion)entity;
                entity = world.m_6815_(this.leftCloudMinionID);
                if (entity instanceof CloudMinion) {
                    CloudMinion cloudMinionLeft = (CloudMinion)entity;
                    AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                        if (aetherPlayer.getCloudMinions().isEmpty()) {
                            aetherPlayer.setCloudMinions(cloudMinionRight, cloudMinionLeft);
                        }
                    });
                }
            }
        }
    }
}

